/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.viewpoint;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.internal.movida.ViewpointDependenciesTracker;
import org.eclipse.sirius.business.internal.movida.ViewpointSelection;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ViewpointSelectionDialog
extends TitleAreaDialog {
    private CheckboxTreeViewer tree;
    private Label description;
    private final ViewpointRegistry registry;
    private final ViewpointSelection selection;
    private final ViewpointDependenciesTracker customizeTracker;
    private final List<Item> input;
    private Multimap<Viewpoint, Item> index = ArrayListMultimap.create();

    public ViewpointSelectionDialog(Shell parentShell, ViewpointRegistry regsitry, ViewpointSelection selection, Collection<String> fileExtensions) {
        super(parentShell);
        this.setShellStyle(68720);
        this.registry = (ViewpointRegistry)Preconditions.checkNotNull((Object)regsitry);
        this.selection = (ViewpointSelection)Preconditions.checkNotNull((Object)selection);
        this.customizeTracker = this.registry.createTrackerFor(this.registry.getRelations().getCustomize());
        this.input = this.computeItemHierarchy(fileExtensions);
    }

    private List<Item> computeItemHierarchy(final Collection<String> fileExtensions) {
        Predicate<Viewpoint> isTopLevel = new Predicate<Viewpoint>(){

            public boolean apply(final Viewpoint vp) {
                boolean top = vp != null && vp.getCustomizes().isEmpty();
                boolean matchesSemancitModel = Iterables.any((Iterable)fileExtensions, (Predicate)new Predicate<String>(){

                    public boolean apply(String ext) {
                        return new ViewpointQuery(vp).handlesSemanticModelExtension(ext);
                    }
                });
                return top && matchesSemancitModel;
            }
        };
        ArrayList roots = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.registry.getViewpoints(), (Predicate)isTopLevel), (Function)new Function<Viewpoint, Item>(){

            public Item apply(Viewpoint from) {
                return new Item(null, from);
            }
        }));
        for (Item item : roots) {
            item.fillDescendants();
        }
        Collections.sort(roots, Ordering.natural().onResultOf((Function)new Function<Item, String>(){

            public String apply(Item from) {
                return from.viewpoint.getName();
            }
        }));
        return roots;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Viewpoints Selection");
        this.setMessage("Select which viewpoints should be enabled in the session.");
        Shell shell = parent.getShell();
        shell.setText("Viewpoints Selection");
        shell.pack();
        shell.setSize(shell.getSize().x, 500);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.tree = new CheckboxTreeViewer(composite);
        this.tree.getTree().setLayoutData((Object)new GridData(1808));
        this.configureTreeViewer();
        Group group = new Group(composite, 4);
        group.setText("Description");
        group.setLayoutData((Object)new GridData(768));
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)group, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.description = new Label((Composite)scrolledComposite, 64);
        scrolledComposite.setContent((Control)this.description);
        return composite;
    }

    private void configureTreeViewer() {
        this.tree.setContentProvider((IContentProvider)new ViewpointSelectionContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Item item = (Item)cell.getElement();
                cell.setText(item.getLabel());
                cell.setImage(SiriusEditPlugin.getPlugin().getBundledImage("icons/full/obj16/Viewpoint.gif"));
            }

            public String getToolTipText(Object element) {
                Item item = (Item)element;
                return item.getViewpointURI().toString();
            }
        });
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof Item) {
                    Item item = (Item)event.getElement();
                    if (event.getChecked()) {
                        item.onChecked();
                    } else if (item.getUiState() == State.GRAY_CHECKED) {
                        item.onChecked();
                    } else {
                        item.onUnchecked();
                    }
                    for (Item root : ViewpointSelectionDialog.this.input) {
                        root.setInitialUiStateRecursive(State.CHECKED);
                    }
                    ViewpointSelectionDialog.this.selection.validate();
                    if (!ViewpointSelectionDialog.this.selection.isValid()) {
                        ViewpointSelectionDialog.this.setErrorMessage(ViewpointSelectionDialog.this.selection.getErrorMessage());
                    } else {
                        ViewpointSelectionDialog.this.setErrorMessage(null);
                    }
                    ViewpointSelectionDialog.this.getButton(0).setEnabled(ViewpointSelectionDialog.this.selection.isValid());
                }
            }
        });
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection) {
                    Item item = (Item)((IStructuredSelection)sel).getFirstElement();
                    if (item != null && item.viewpoint != null) {
                        ViewpointSelectionDialog.this.description.setText(item.viewpoint.getEndUserDocumentation());
                    } else {
                        ViewpointSelectionDialog.this.description.setText("");
                    }
                } else {
                    ViewpointSelectionDialog.this.description.setText("");
                }
            }
        });
        this.tree.setInput(this.input);
        for (Item root : this.input) {
            root.setInitialUiStateRecursive(State.CHECKED);
        }
    }

    public boolean close() {
        this.customizeTracker.dispose();
        return super.close();
    }

    private class Item {
        public final Viewpoint viewpoint;
        public final Item parent;
        public final List<Item> descendants = Lists.newArrayList();

        public Item(Item parent, Viewpoint vp) {
            this.parent = parent;
            this.viewpoint = vp;
            ViewpointSelectionDialog.this.index.put((Object)this.viewpoint, (Object)this);
        }

        public String getLabel() {
            return this.viewpoint.getName();
        }

        public URI getViewpointURI() {
            return (URI)new ViewpointQuery(this.viewpoint).getViewpointURI().get();
        }

        private void addToSelection() {
            ViewpointSelectionDialog.this.selection.select(this.getViewpointURI());
        }

        private void removeFromSelection() {
            ViewpointSelectionDialog.this.selection.deselect(this.getViewpointURI());
        }

        private boolean isInSelection() {
            return ViewpointSelectionDialog.this.selection.getSelected().contains(this.getViewpointURI());
        }

        public void onChecked() {
            Item current = this;
            while (current != null) {
                current.addToSelection();
                current = current.parent;
            }
        }

        public void onUnchecked() {
            this.onUnchecked(this);
        }

        private void onUnchecked(Item unchecked) {
            if (unchecked == this) {
                this.removeFromSelection();
            } else if (this.isInSelection() && Iterables.all((Iterable)Iterables.filter((Iterable)ViewpointSelectionDialog.this.index.get((Object)this.viewpoint), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)this))), (Predicate)new Predicate<Item>(){

                public boolean apply(Item input) {
                    return input.parent != null && !input.parent.isInSelection();
                }
            })) {
                this.removeFromSelection();
            }
            for (Item child : this.descendants) {
                child.onUnchecked(unchecked);
            }
        }

        public void setInitialUiStateRecursive(State parentState) {
            if (this.isInSelection()) {
                if (parentState == State.CHECKED) {
                    this.setUiState(State.CHECKED);
                } else {
                    this.setUiState(State.GRAY_CHECKED);
                }
            } else {
                this.setUiState(State.UNCHECKED);
            }
            for (Item child : this.descendants) {
                child.setInitialUiStateRecursive(this.getUiState());
            }
        }

        protected State getUiState() {
            if (ViewpointSelectionDialog.this.tree.getGrayed((Object)this)) {
                return State.GRAY_CHECKED;
            }
            if (ViewpointSelectionDialog.this.tree.getChecked((Object)this)) {
                return State.CHECKED;
            }
            return State.UNCHECKED;
        }

        protected void setUiState(State s) {
            switch (s) {
                case CHECKED: {
                    ViewpointSelectionDialog.this.tree.setChecked((Object)this, true);
                    ViewpointSelectionDialog.this.tree.setGrayed((Object)this, false);
                    break;
                }
                case GRAY_CHECKED: {
                    ViewpointSelectionDialog.this.tree.setGrayChecked((Object)this, true);
                    break;
                }
                case UNCHECKED: {
                    ViewpointSelectionDialog.this.tree.setChecked((Object)this, false);
                }
            }
        }

        public void fillDescendants() {
            URI uri = this.getViewpointURI();
            for (URI childURI : ViewpointSelectionDialog.this.customizeTracker.getReverseDependencies((Object)uri)) {
                Item child = new Item(this, ViewpointSelectionDialog.this.registry.getViewpoint(childURI));
                this.descendants.add(child);
                child.fillDescendants();
            }
            Collections.sort(this.descendants, Ordering.natural().onResultOf((Function)new Function<Item, String>(){

                public String apply(Item from) {
                    return from.viewpoint.getName();
                }
            }));
        }

        public String toString() {
            if (this.parent != null) {
                return String.valueOf(this.parent.toString()) + " > " + this.getLabel();
            }
            return this.getLabel();
        }
    }

    static enum State {
        CHECKED,
        GRAY_CHECKED,
        UNCHECKED;

    }

    private final class ViewpointSelectionContentProvider
    implements ITreeContentProvider {
        private ViewpointSelectionContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List && Iterables.all((Iterable)((List)inputElement), (Predicate)Predicates.instanceOf(Item.class))) {
                List topItems = (List)inputElement;
                return topItems.toArray();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Item) {
                return !((Item)element).descendants.isEmpty();
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof Item) {
                return ((Item)element).parent;
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Item) {
                return ((Item)parentElement).descendants.toArray();
            }
            return null;
        }
    }
}

