/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.sorter.CommonItemSorter;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SemanticElementSelectionWizardPage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class RepresentationSelectionWizardPage
extends WizardPage {
    private static final String SELECT_REPRESENTATIONS = "Select a representation type";
    private static final String PAGE_TITLE = "Create a new representation";
    private TreeViewer treeViewer;
    private final Session root;
    private Composite pageComposite;
    private RepresentationDescription representation;
    private SemanticElementSelectionWizardPage selectionWizard;

    public RepresentationSelectionWizardPage(Session root) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.root = root;
        this.setMessage(SELECT_REPRESENTATIONS);
    }

    public boolean canFlipToNextPage() {
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof RepresentationDescription) {
            this.setRepresentation((RepresentationDescription)((StructuredSelection)selection).getFirstElement());
            return true;
        }
        return false;
    }

    private void setRepresentation(RepresentationDescription firstElement) {
        this.representation = firstElement;
    }

    public RepresentationDescription getRepresentation() {
        return this.representation;
    }

    public void setSelectionWizard(SemanticElementSelectionWizardPage selectionWizard) {
        this.selectionWizard = selectionWizard;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.treeViewer = this.createTreeViewer(this.pageComposite);
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof Viewpoint) || !((Viewpoint)element).getOwnedRepresentations().isEmpty();
            }
        });
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.expandAll();
        this.treeViewer.collapseAll();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepresentationSelectionWizardPage.this.setPageComplete(RepresentationSelectionWizardPage.this.isPageComplete());
                if (RepresentationSelectionWizardPage.this.selectionWizard != null) {
                    RepresentationSelectionWizardPage.this.selectionWizard.setRepresentation(RepresentationSelectionWizardPage.this.getRepresentation());
                    RepresentationSelectionWizardPage.this.selectionWizard.update();
                }
            }
        });
        this.setControl((Control)this.pageComposite);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        FilteredTree tree = SWTUtil.createFilteredTree((Composite)parent, (int)2820, (PatternFilter)new PatternFilter());
        TreeViewer viewer = tree.getViewer();
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTree().setHeaderVisible(false);
        viewer.getTree().setLinesVisible(false);
        viewer.setContentProvider((IContentProvider)new SessionContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()));
        return viewer;
    }

    public boolean isCurrentPageOnWizard() {
        return super.isCurrentPage();
    }

    private static final class SessionContentProvider
    implements ITreeContentProvider {
        private static Object[] empty = new Object[0];

        public Object[] getChildren(Object parentElement) {
            Object[] children = empty;
            if (parentElement instanceof Session) {
                children = ((Session)parentElement).getSelectedViewpoints(false).toArray();
            } else if (parentElement instanceof Viewpoint) {
                ArrayList reps = Lists.newArrayList((Iterable)((Viewpoint)parentElement).getOwnedRepresentations());
                Collections.sort(reps, new Comparator<RepresentationDescription>(){

                    @Override
                    public int compare(RepresentationDescription rep1, RepresentationDescription rep2) {
                        return CommonItemSorter.compareRepresentationDescriptions(rep1, rep2);
                    }
                });
                children = reps.toArray();
            }
            return children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

