/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.parser;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileExtendedMetaData;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileResourceHandler;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileVersionSAXParser;
import org.eclipse.sirius.business.internal.resource.parser.AirDResourceImpl;
import org.eclipse.sirius.common.tools.api.resource.ResourceMigrationMarker;
import org.osgi.framework.Version;

public class AirDResourceFactory
extends XMIResourceFactoryImpl {
    private static final String XMI_ENCODING = "UTF-8";
    private static final Map<Object, Object> DEFAULT_LOAD_OPTIONS = Maps.newHashMap();
    private static final Map<Object, Object> DEFAULT_SAVE_OPTIONS = Maps.newHashMap();
    private RepresentationsFileExtendedMetaData extendedMetaData;
    private RepresentationsFileResourceHandler resourceHandler;

    static {
        XMIResourceImpl resource = new XMIResourceImpl();
        DEFAULT_LOAD_OPTIONS.putAll(resource.getDefaultLoadOptions());
        DEFAULT_LOAD_OPTIONS.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        DEFAULT_SAVE_OPTIONS.putAll(resource.getDefaultSaveOptions());
        DEFAULT_SAVE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        DEFAULT_SAVE_OPTIONS.put("PROCESS_DANGLING_HREF", "DISCARD");
        DEFAULT_SAVE_OPTIONS.put("SCHEMA_LOCATION", Boolean.TRUE);
        DEFAULT_SAVE_OPTIONS.put("USE_XMI_TYPE", Boolean.TRUE);
        DEFAULT_SAVE_OPTIONS.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        DEFAULT_SAVE_OPTIONS.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        DEFAULT_SAVE_OPTIONS.put("ENCODING", XMI_ENCODING);
    }

    public static Map<Object, Object> getDefaultLoadOptions() {
        return DEFAULT_LOAD_OPTIONS;
    }

    public static Map<Object, Object> getDefaultSaveOptions() {
        return DEFAULT_SAVE_OPTIONS;
    }

    public Resource createResource(URI uri) {
        RepresentationsFileVersionSAXParser parser = new RepresentationsFileVersionSAXParser(uri);
        boolean migrationIsNeeded = true;
        String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        if (loadedVersion != null) {
            migrationIsNeeded = RepresentationsFileMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)loadedVersion));
        }
        if (migrationIsNeeded) {
            this.extendedMetaData = new RepresentationsFileExtendedMetaData(loadedVersion);
            this.resourceHandler = new RepresentationsFileResourceHandler(loadedVersion);
        }
        XMIResource resource = this.doCreateAirdResourceImpl(uri);
        this.setLoadOptions(resource, migrationIsNeeded);
        this.setSaveOptions(resource, migrationIsNeeded);
        if (!resource.getEncoding().equals(XMI_ENCODING)) {
            resource.setEncoding(XMI_ENCODING);
        }
        if (migrationIsNeeded) {
            ResourceMigrationMarker.addMigrationMarker((Resource)resource);
        }
        return resource;
    }

    protected XMIResource doCreateAirdResourceImpl(URI uri) {
        return new AirDResourceImpl(uri);
    }

    private void setLoadOptions(XMIResource resource, boolean migrationIsNeeded) {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.putAll(AirDResourceFactory.getDefaultLoadOptions());
        options.put("DEFER_ATTACHMENT", true);
        options.put("DEFER_IDREF_RESOLUTION", true);
        options.put("USE_DEPRECATED_METHODS", false);
        options.put("USE_PARSER_POOL", new XMLParserPoolImpl(true));
        options.put("USE_XML_NAME_TO_FEATURE_MAP", Maps.newHashMap());
        if (migrationIsNeeded) {
            options.put("EXTENDED_META_DATA", (Object)this.extendedMetaData);
            options.put("RESOURCE_HANDLER", (Object)this.resourceHandler);
        }
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        resource.getDefaultLoadOptions().putAll(options);
    }

    private void setSaveOptions(XMIResource resource, boolean migrationIsNeeded) {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.putAll(AirDResourceFactory.getDefaultSaveOptions());
        if (migrationIsNeeded) {
            options.put("EXTENDED_META_DATA", (Object)this.extendedMetaData);
            options.put("RESOURCE_HANDLER", (Object)this.resourceHandler);
        }
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        resource.getDefaultSaveOptions().putAll(options);
    }
}

