/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointURIConverter;
import org.eclipse.sirius.business.internal.resource.parser.AirDCrossReferenceAdapterImpl;
import org.eclipse.sirius.business.internal.session.SessionFactoryService;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.tools.internal.resource.ResourceSetUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointFactory;

public final class SessionFactoryImpl
implements SessionFactory {
    private SessionFactoryImpl() {
    }

    public static SessionFactory init() {
        SessionFactory sessionFactory = SessionFactoryService.INSTANCE.getSessionFactory();
        if (sessionFactory == null) {
            sessionFactory = new SessionFactoryImpl();
        }
        return sessionFactory;
    }

    public Session createSession(URI sessionResourceURI) throws CoreException {
        return this.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public Session createSession(URI sessionResourceURI, IProgressMonitor monitor) throws CoreException {
        ResourceSet set = ResourceSetFactory.createFactory().createResourceSet(sessionResourceURI);
        TransactionalEditingDomain transactionalEditingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain(set);
        transactionalEditingDomain.getResourceSet().eAdapters().add((Object)new AirDCrossReferenceAdapterImpl());
        if (Movida.isEnabled()) {
            transactionalEditingDomain.getResourceSet().setURIConverter((URIConverter)new ViewpointURIConverter((ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance()));
        }
        if (set instanceof ResourceSetImpl) {
            ResourceSetImpl resourceSetImpl = (ResourceSetImpl)set;
            new ResourceSetImpl.MappedResourceLocator(resourceSetImpl);
        }
        set.getLoadOptions().put("SIRIUS_USE_URI_FRAGMENT_AS_ID", true);
        boolean alreadyExistingResource = set.getURIConverter().exists(sessionResourceURI, null);
        Session session = null;
        session = alreadyExistingResource ? this.loadSessionModelResource(sessionResourceURI, transactionalEditingDomain, monitor) : this.createSessionResource(sessionResourceURI, transactionalEditingDomain, monitor);
        return session;
    }

    private Session loadSessionModelResource(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain, IProgressMonitor monitor) throws CoreException {
        ResourceSet resourceSet = transactionalEditingDomain.getResourceSet();
        ResourceSetUtil.setProgressMonitor(resourceSet, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        Session session = null;
        try {
            try {
                monitor.beginTask("Session loading", 4);
                Resource sessionModelResource = resourceSet.getResource(sessionResourceURI, true);
                if (sessionModelResource != null) {
                    DAnalysis analysis = null;
                    if (!sessionModelResource.getContents().isEmpty() && sessionModelResource.getContents().get(0) instanceof DAnalysis) {
                        analysis = (DAnalysis)sessionModelResource.getContents().get(0);
                        session = new DAnalysisSessionImpl(analysis);
                        monitor.worked(2);
                    } else {
                        session = this.createSessionResource(sessionResourceURI, transactionalEditingDomain, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                }
            }
            catch (WrappedException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "Error while loading representations file", (Throwable)e));
            }
        }
        finally {
            monitor.done();
            ResourceSetUtil.resetProgressMonitor(resourceSet);
        }
        return session;
    }

    private Session createSessionResource(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain, IProgressMonitor monitor) throws CoreException {
        DAnalysisSessionImpl session = null;
        try {
            monitor.beginTask("Session creation", 2);
            Resource sessionModelResource = new ResourceSetImpl().createResource(sessionResourceURI);
            DAnalysis analysis = ViewpointFactory.eINSTANCE.createDAnalysis();
            sessionModelResource.getContents().add((Object)analysis);
            try {
                sessionModelResource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "session creation failed", (Throwable)e));
            }
            monitor.worked(1);
            sessionModelResource = transactionalEditingDomain.getResourceSet().getResource(sessionResourceURI, true);
            if (sessionModelResource.getContents().isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "session creation failed: the resource content is empty."));
            }
            analysis = (DAnalysis)sessionModelResource.getContents().get(0);
            session = new DAnalysisSessionImpl(analysis);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return session;
    }

    @Override
    public Session createDefaultSession(URI sessionResourceURI) throws CoreException {
        return this.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
    }
}

