/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.internal.resource.AirDCrossReferenceAdapter;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;

public class ReloadRepresentationsFileCmd
extends RecordingCommand {
    private Session session;
    private Resource resource;
    private DAnalysis oldAnalysis;

    public ReloadRepresentationsFileCmd(Session session, TransactionalEditingDomain domain, String name, Resource analysisResource) {
        super(domain, name);
        this.session = session;
        this.resource = analysisResource;
        EList contents = analysisResource.getContents();
        this.oldAnalysis = contents.isEmpty() ? null : (DAnalysis)contents.get(0);
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    protected void doExecute() {
        DAnalysisSession analysisSession = this.getAnalysisSession();
        DAnalysisSessionEObject analysisSessionEObject = this.getAnalysisSessionEObject();
        this.removeOldAnalysis(analysisSession, analysisSessionEObject);
        this.addNewAnalysis(analysisSession, analysisSessionEObject);
        this.session = null;
        this.resource = null;
        this.oldAnalysis = null;
    }

    private void addNewAnalysis(DAnalysisSession analysisSession, DAnalysisSessionEObject analysisSessionEObject) {
        if (this.resource != null) {
            Adapter existingAirDCrossReferenceAdapter;
            DAnalysis analysis = (DAnalysis)this.resource.getContents().get(0);
            if (analysis != null) {
                if (analysisSessionEObject != null) {
                    analysisSessionEObject.getAnalyses().add((Object)analysis);
                }
                if (analysisSession != null) {
                    analysisSession.addAdaptersOnAnalysis(analysis);
                }
            }
            if (EcoreUtil.getExistingAdapter((Notifier)this.resource, AirDCrossReferenceAdapter.class) == null && (existingAirDCrossReferenceAdapter = EcoreUtil.getExistingAdapter((Notifier)this.resource.getResourceSet(), AirDCrossReferenceAdapter.class)) instanceof AirDCrossReferenceAdapter) {
                this.resource.eAdapters().add((Object)existingAirDCrossReferenceAdapter);
            }
        }
    }

    private void removeOldAnalysis(DAnalysisSession analysisSession, DAnalysisSessionEObject analysisSessionEObject) {
        if (this.oldAnalysis != null) {
            if (analysisSessionEObject != null) {
                analysisSessionEObject.getAnalyses().remove((Object)this.oldAnalysis);
            }
            if (analysisSession != null) {
                analysisSession.removeAdaptersOnAnalysis(this.oldAnalysis);
            }
        }
    }

    private DAnalysisSessionEObject getAnalysisSessionEObject() {
        DAnalysisSessionEObject analysisSessionEObject = null;
        if (this.session instanceof DAnalysisSessionEObject) {
            analysisSessionEObject = (DAnalysisSessionEObject)((Object)this.session);
        }
        return analysisSessionEObject;
    }

    private DAnalysisSession getAnalysisSession() {
        DAnalysisSession analysisSession = null;
        if (this.session instanceof DAnalysisSession) {
            analysisSession = (DAnalysisSession)this.session;
        }
        return analysisSession;
    }
}

