/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.internal.helper.delete.DeleteHookDescriptorRegistryListener;
import org.eclipse.sirius.business.internal.session.factory.SessionFactoryRegistryListener;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessorsRegistry;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tools.internal.ui.ExternalJavaActionRegistryListener;
import org.eclipse.sirius.tools.internal.validation.EValidatorAdapter;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.osgi.framework.BundleContext;

public final class SiriusPlugin
extends Plugin {
    public static final boolean IS_ECLIPSE_RUNNING;
    public static final String ID = "org.eclipse.sirius";
    private static SiriusPlugin defaultPlugin;
    private static final ModelAccessorsRegistry REGISTRY;
    private static final InterpreterRegistry INTER_REGISTRY;
    private SessionFactoryRegistryListener sessionFactoryRegistryListener;
    private DeleteHookDescriptorRegistryListener deleteHookDescriptorRegistryListener;
    private ExternalJavaActionRegistryListener javaActionRegistryListener;

    static {
        boolean result = false;
        try {
            result = Platform.isRunning();
        }
        catch (Throwable throwable) {}
        IS_ECLIPSE_RUNNING = result;
        REGISTRY = new ModelAccessorsRegistry("odesign");
        INTER_REGISTRY = new InterpreterRegistry();
    }

    public SiriusPlugin() {
        defaultPlugin = this;
    }

    public static SiriusPlugin getDefault() {
        return defaultPlugin;
    }

    public void error(String message, Throwable e) {
        String messageToDisplay = message;
        if (messageToDisplay == null && e != null) {
            messageToDisplay = e.getMessage();
        }
        if (e instanceof CoreException) {
            this.getLog().log(((CoreException)e).getStatus());
        } else {
            Status status = new Status(4, this.getBundle().getSymbolicName(), messageToDisplay, e);
            this.getLog().log((IStatus)status);
        }
    }

    public void warning(String message, Exception e) {
        String messageToDisplay = message;
        if (messageToDisplay == null && e != null) {
            messageToDisplay = e.getMessage();
        }
        if (e instanceof CoreException) {
            this.getLog().log(((CoreException)e).getStatus());
        } else {
            Status status = new Status(2, this.getBundle().getSymbolicName(), messageToDisplay, (Throwable)e);
            this.getLog().log((IStatus)status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        EValidator.Registry.INSTANCE.put((Object)ViewpointPackage.eINSTANCE, (Object)new EValidatorAdapter());
        EValidator.Registry.INSTANCE.put((Object)DescriptionPackage.eINSTANCE, (Object)new EValidatorAdapter());
        EValidator.Registry.INSTANCE.put((Object)ToolPackage.eINSTANCE, (Object)new EValidatorAdapter());
        this.sessionFactoryRegistryListener = new SessionFactoryRegistryListener();
        this.sessionFactoryRegistryListener.init();
        this.deleteHookDescriptorRegistryListener = new DeleteHookDescriptorRegistryListener();
        this.deleteHookDescriptorRegistryListener.init();
        this.javaActionRegistryListener = new ExternalJavaActionRegistryListener();
        this.javaActionRegistryListener.init();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        REGISTRY.dispose();
        this.sessionFactoryRegistryListener.dispose();
        this.sessionFactoryRegistryListener = null;
        this.deleteHookDescriptorRegistryListener.dispose();
        this.deleteHookDescriptorRegistryListener = null;
        this.javaActionRegistryListener.dispose();
        this.javaActionRegistryListener = null;
        ViewpointRegistry.getInstance().dispose();
    }

    public ModelAccessorsRegistry getModelAccessorRegistry() {
        return REGISTRY;
    }

    public InterpreterRegistry getInterpreterRegistry() {
        return INTER_REGISTRY;
    }
}

