/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ConnectionLineSegEditPolicy;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.internal.command.TreeLayoutSetConnectionBendpointsCommand;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class TreeLayoutConnectionLineSegEditPolicy
extends ConnectionLineSegEditPolicy {
    protected Command getBendpointsChangedCommand(Connection connection, Edge edge) {
        boolean isTreeLayout = false;
        if (new ConnectionQuery(connection).isOrthogonalTreeBranch(connection.getPoints()) && this.getHost() instanceof ConnectionEditPart && new ConnectionEditPartQuery((org.eclipse.gef.ConnectionEditPart)((ConnectionEditPart)this.getHost())).isLayoutComponent()) {
            isTreeLayout = true;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (!isTreeLayout) {
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.add(super.getBendpointsChangedCommand(connection, edge));
            ICommand command = CommandFactory.createICommand(editingDomain, new CenterEdgeEndModelChangeOperation((ConnectionEditPart)this.getHost(), edge));
            compoundCommand.add((Command)new ICommandProxy(command));
            return compoundCommand;
        }
        Point ptRef1 = connection.getSourceAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef1);
        Point ptRef2 = connection.getTargetAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef2);
        TreeLayoutSetConnectionBendpointsCommand sbbCommand = new TreeLayoutSetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
        sbbCommand.setNewPointList(connection.getPoints(), ptRef1, ptRef2);
        return new ICommandProxy((ICommand)sbbCommand);
    }
}

