/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.figures;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class CanonicalRectilinearRouter {
    private static int maxNestedRoutingDepth = 1;

    public void routeLine(Edge edge, int nestedRoutingDepth, PointList newLine, Rectangle srcAbsoluteBounds, Rectangle tgtAbsoluteBounds) {
        Ray middleSeg;
        boolean skipNormalization = false;
        if (edge.getSource() == edge.getTarget()) {
            nestedRoutingDepth = maxNestedRoutingDepth;
        }
        Point lastStartAnchor = newLine.removePoint(0);
        Point lastEndAnchor = newLine.removePoint(newLine.size() - 1);
        if (!OrthogonalRouterUtilities.isRectilinear((PointList)newLine)) {
            OrthogonalRouterUtilities.transformToOrthogonalPointList((PointList)newLine, (int)0, (int)0);
        }
        CanonicalRectilinearRouter.removeRedundantPoints(newLine);
        this.removePointsInViews(edge, newLine, lastStartAnchor, lastEndAnchor, srcAbsoluteBounds, tgtAbsoluteBounds);
        Dimension tolerance = new Dimension(3, 0);
        if (!skipNormalization) {
            PointListUtilities.normalizeSegments((PointList)newLine, (int)tolerance.width);
        }
        if (newLine.size() == 2 && (middleSeg = new Ray(newLine.getFirstPoint(), newLine.getLastPoint())).length() <= (double)tolerance.width) {
            newLine.removePoint(0);
        }
        this.resetEndPointsToEdge(edge, newLine, srcAbsoluteBounds, tgtAbsoluteBounds);
    }

    protected void resetEndPointsToEdge(Edge edge, PointList line, Rectangle source, Rectangle target) {
        PrecisionPoint sourceAnchor = this.getAnchorId(edge.getSourceAnchor());
        PrecisionPoint targetAnchor = this.getAnchorId(edge.getTargetAnchor());
        Point srcAnchorPoint = this.getAbsoluteAnchorCoordinates(source, sourceAnchor);
        Point targetAnchorPoint = this.getAbsoluteAnchorCoordinates(target, targetAnchor);
        int offSourceDirection = 0;
        int offTargetDirection = 0;
        int sourceAnchorRelativeLocation = 0;
        int targetAnchorRelativeLocation = 0;
        if (line.size() == 0) {
            this.computePointListByIntersections(line, source, target, srcAnchorPoint, targetAnchorPoint);
            sourceAnchorRelativeLocation = CanonicalRectilinearRouter.getAnchorOffRectangleDirection(line.getFirstPoint(), source);
            targetAnchorRelativeLocation = CanonicalRectilinearRouter.getAnchorOffRectangleDirection(line.getLastPoint(), target);
            Point offStart = line.getFirstPoint();
            Point offEnd = line.getLastPoint();
            Dimension offsetDim = offStart.getDifference(offEnd).scale(0.5);
            offStart.translate(CanonicalRectilinearRouter.getTranslationValue(sourceAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
            offEnd.translate(CanonicalRectilinearRouter.getTranslationValue(targetAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
            line.insertPoint(offStart, 1);
            line.insertPoint(offEnd, 2);
            offSourceDirection = CanonicalRectilinearRouter.getOffShapeDirection(sourceAnchorRelativeLocation);
            offTargetDirection = CanonicalRectilinearRouter.getOffShapeDirection(targetAnchorRelativeLocation);
        } else {
            Point start = line.getFirstPoint();
            Point end = line.getLastPoint();
            line.insertPoint(this.getOrthogonalInterserction(start, source, sourceAnchor), 0);
            line.addPoint(this.getOrthogonalInterserction(end, target, targetAnchor));
            sourceAnchorRelativeLocation = CanonicalRectilinearRouter.getAnchorOffRectangleDirection(line.getFirstPoint(), source);
            offSourceDirection = CanonicalRectilinearRouter.getOffShapeDirection(sourceAnchorRelativeLocation);
            targetAnchorRelativeLocation = CanonicalRectilinearRouter.getAnchorOffRectangleDirection(line.getLastPoint(), target);
            offTargetDirection = CanonicalRectilinearRouter.getOffShapeDirection(targetAnchorRelativeLocation);
        }
        OrthogonalRouterUtilities.transformToOrthogonalPointList((PointList)line, (int)offSourceDirection, (int)offTargetDirection);
        CanonicalRectilinearRouter.removeRedundantPoints(line);
    }

    private Point getOrthogonalInterserction(Point start, Rectangle bounds, PrecisionPoint anchor) {
        Point anchorAbsCoordinate = this.getAbsoluteAnchorCoordinates(bounds, anchor);
        PointList intersections = GraphicalHelper.getIntersectionPoints((Point)start, (Point)anchorAbsCoordinate, (Rectangle)bounds);
        if (intersections.size() > 0) {
            Point intersection = intersections.getFirstPoint();
            int direction = 0;
            if (start.x() >= bounds.x() && start.x() <= bounds.x() + bounds.width()) {
                direction = 128;
            } else if (start.y() >= bounds.y() && start.y() <= bounds.y() + bounds.height()) {
                direction = 64;
            }
            if (direction == 128) {
                intersection.setX(start.x());
            } else if (direction == 64) {
                intersection.setY(start.y());
            }
            return intersection;
        }
        return anchorAbsCoordinate;
    }

    private PrecisionPoint getAnchorId(Anchor anchor) {
        PrecisionPoint anchorId = new PrecisionPoint(0.5, 0.5);
        if (anchor instanceof IdentityAnchor) {
            anchorId = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)anchor).getId());
        }
        return anchorId;
    }

    private void computePointListByIntersections(PointList list, Rectangle sourceBounds, Rectangle targetBounds, Point sourceAnchor, Point targetAnchor) {
        PointList srcIntersections = GraphicalHelper.getIntersectionPoints((Point)targetAnchor, (Point)sourceAnchor, (Rectangle)sourceBounds);
        PointList tgtIntersections = GraphicalHelper.getIntersectionPoints((Point)sourceAnchor, (Point)targetAnchor, (Rectangle)targetBounds);
        if (srcIntersections.size() > 0 && tgtIntersections.size() > 0) {
            list.removeAllPoints();
            list.addPoint(srcIntersections.getFirstPoint());
            list.addPoint(tgtIntersections.getFirstPoint());
        }
    }

    private Point getAbsoluteAnchorCoordinates(Rectangle absoluteBounds, PrecisionPoint precisionPoint) {
        return new Point((int)((long)absoluteBounds.x() + Math.round((double)absoluteBounds.width() * precisionPoint.preciseX())), (int)((long)absoluteBounds.y() + Math.round((double)absoluteBounds.height() * precisionPoint.preciseY())));
    }

    private void removePointsInViews(Edge edge, PointList newLine, Point start, Point end, Rectangle source, Rectangle target) {
        int i;
        if (edge.getSource() == edge.getTarget()) {
            return;
        }
        Point lastRemovedFromSource = null;
        Point lastRemovedFromTarget = null;
        if (newLine.size() != 0 && source.contains((Point)new PrecisionPoint(newLine.getFirstPoint()))) {
            lastRemovedFromSource = newLine.removePoint(0);
            i = 0;
            while (i < newLine.size() && source.contains((Point)new PrecisionPoint(newLine.getPoint(i)))) {
                lastRemovedFromSource = newLine.removePoint(i--);
                ++i;
            }
        }
        if (newLine.size() != 0 && target.contains((Point)new PrecisionPoint(newLine.getLastPoint()))) {
            lastRemovedFromTarget = newLine.removePoint(newLine.size() - 1);
            i = newLine.size();
            while (i > 0 && target.contains((Point)new PrecisionPoint(newLine.getPoint(i - 1)))) {
                lastRemovedFromTarget = newLine.removePoint(i - 1);
                --i;
            }
        }
        if (newLine.size() == 0) {
            Dimension tolerance = new Dimension(1, 0);
            int toleranceValue = tolerance.width;
            if (lastRemovedFromSource == null) {
                lastRemovedFromSource = start;
            }
            if (lastRemovedFromTarget == null) {
                lastRemovedFromTarget = end;
            }
            if (Math.abs(lastRemovedFromSource.x - lastRemovedFromTarget.x) < toleranceValue) {
                if (source.y < target.y) {
                    newLine.addPoint(lastRemovedFromSource.x, (source.getBottom().y + target.getTop().y) / 2);
                } else {
                    newLine.addPoint(lastRemovedFromSource.x, (source.getTop().y + target.getBottom().y) / 2);
                }
            } else if (Math.abs(lastRemovedFromSource.y - lastRemovedFromTarget.y) < toleranceValue) {
                if (source.x < target.x) {
                    newLine.addPoint((source.getRight().x + target.getLeft().x) / 2, lastRemovedFromSource.y);
                } else {
                    newLine.addPoint((source.getLeft().x + target.getRight().x) / 2, lastRemovedFromSource.y);
                }
            } else if (edge.getSourceAnchor() instanceof IdentityAnchor && "".equals(((IdentityAnchor)edge.getSourceAnchor()).getId()) && edge.getTargetAnchor() instanceof IdentityAnchor && "".equals(((IdentityAnchor)edge.getTargetAnchor()).getId())) {
                if (lastRemovedFromSource != null && lastRemovedFromTarget != null) {
                    newLine.addPoint((lastRemovedFromSource.x + lastRemovedFromTarget.x) / 2, (lastRemovedFromSource.y + lastRemovedFromTarget.y) / 2);
                } else {
                    double startX = Math.max(source.x, target.x);
                    double endX = Math.min(source.x + source.width, target.x + target.width);
                    double startY = Math.max(source.y, target.y);
                    double endY = Math.min(source.y + source.height, target.y + target.height);
                    if (startX < endX) {
                        if (source.y < target.y) {
                            newLine.addPoint((int)Math.round((startX + endX) / 2.0), (source.getBottom().y + target.getTop().y) / 2);
                        } else {
                            newLine.addPoint((int)Math.round((startX + endX) / 2.0), (source.getTop().y + target.getBottom().y) / 2);
                        }
                    } else if (startY < endY) {
                        if (source.x < target.x) {
                            newLine.addPoint((source.getRight().x + target.getLeft().x) / 2, (int)Math.round((startY + endY) / 2.0));
                        } else {
                            newLine.addPoint((source.getLeft().x + target.getRight().x) / 2, (int)Math.round((startY + endY) / 2.0));
                        }
                    }
                }
            }
        }
    }

    private static Dimension getTranslationValue(int position, int xFactorValue, int yFactorValue) {
        Dimension translationDimension = new Dimension();
        if (position == 16) {
            translationDimension.width = xFactorValue;
        } else if (position == 4) {
            translationDimension.height = yFactorValue;
        } else if (position == 8) {
            translationDimension.width = -xFactorValue;
        } else if (position == 1) {
            translationDimension.height = -yFactorValue;
        }
        return translationDimension;
    }

    private static int getAnchorOffRectangleDirection(Point anchorPoint, Rectangle rect) {
        int position = 1;
        int criteriaValue = Math.abs(anchorPoint.y - rect.y);
        int tempCriteria = Math.abs(anchorPoint.y - rect.y - rect.height);
        if (tempCriteria < criteriaValue) {
            criteriaValue = tempCriteria;
            position = 4;
        }
        if ((tempCriteria = Math.abs(anchorPoint.x - rect.x)) < criteriaValue) {
            criteriaValue = tempCriteria;
            position = 8;
        }
        if ((tempCriteria = Math.abs(anchorPoint.x - rect.x - rect.width)) < criteriaValue) {
            criteriaValue = tempCriteria;
            position = 16;
        }
        return position;
    }

    private static int getOffShapeDirection(int anchorRelativeLocation) {
        if (anchorRelativeLocation == 16 || anchorRelativeLocation == 8) {
            return 64;
        }
        if (anchorRelativeLocation == 1 || anchorRelativeLocation == 4) {
            return 128;
        }
        return 0;
    }

    private static boolean removeRedundantPoints(PointList line) {
        int initialNumberOfPoints = line.size();
        if (line.size() > 2) {
            PointList newLine = new PointList(line.size());
            newLine.addPoint(line.removePoint(0));
            while (line.size() >= 2) {
                Point p0 = newLine.getLastPoint();
                Point p1 = line.getPoint(0);
                Point p2 = line.getPoint(1);
                if (p0.x == p1.x && p0.x == p2.x) {
                    line.removePoint(0);
                    continue;
                }
                if (p0.y == p1.y && p0.y == p2.y) {
                    line.removePoint(0);
                    continue;
                }
                newLine.addPoint(line.removePoint(0));
            }
            while (line.size() > 0) {
                newLine.addPoint(line.removePoint(0));
            }
            line.removeAllPoints();
            line.addAll(newLine);
        }
        return line.size() != initialNumberOfPoints;
    }

    private boolean checkSelfRelConnection(Edge edge, PointList newLine) {
        return false;
    }
}

