/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.CallBack;
import org.eclipse.sirius.viewpoint.DNavigationLink;
import org.eclipse.ui.IEditorPart;

public class DelegatingCallBack
implements CallBack {
    private List<CallBack> callBacks = new ArrayList<CallBack>();

    @Override
    public void postOpeningRun(DNavigationLink link, IEditorPart editor) {
        for (CallBack callBack : this.callBacks) {
            callBack.postOpeningRun(link, editor);
        }
    }

    public void addCallBack(CallBack callBack) {
        this.callBacks.add(callBack);
    }

    public void removeCallBack(CallBack callBack) {
        this.callBacks.remove(callBack);
    }

    public static CallBack createCallBack(CallBack callBack, CallBack anotherCallBack) {
        CallBack ret = null;
        if (anotherCallBack == null) {
            ret = callBack;
        } else if (anotherCallBack instanceof DelegatingCallBack) {
            ((DelegatingCallBack)anotherCallBack).addCallBack(callBack);
            ret = anotherCallBack;
        } else {
            DelegatingCallBack delegatingCallBack = new DelegatingCallBack();
            delegatingCallBack.addCallBack(anotherCallBack);
            delegatingCallBack.addCallBack(callBack);
        }
        return ret;
    }
}

