/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.print;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.JPSDiagramPrinter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class SiriusJPSRenderedDiagramPrinter
extends JPSDiagramPrinter {
    private PrintService printService;

    public SiriusJPSRenderedDiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        super(preferencesHint, mm);
    }

    public void setPrinter(String printerName) {
        HashPrintServiceAttributeSet attributes = new HashPrintServiceAttributeSet(new PrinterName(printerName, Locale.getDefault()));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, attributes);
        this.printService = services[0];
    }

    public void run() {
        Iterator it = this.diagrams.iterator();
        Shell shell = new Shell();
        try {
            while (it.hasNext()) {
                IPreferenceStore preferenceStore;
                Diagram diagram = (Diagram)it.next();
                DiagramEditor openedDiagramEditor = this.getDiagramEditor(diagram);
                DiagramEditPart dgrmEP = openedDiagramEditor == null ? PrintHelperUtil.createDiagramEditPart((Diagram)diagram, (PreferencesHint)this.preferencesHint, (Shell)shell) : openedDiagramEditor.getDiagramEditPart();
                boolean loadedPreferences = openedDiagramEditor != null || PrintHelperUtil.initializePreferences((DiagramEditPart)dgrmEP, (PreferencesHint)this.preferencesHint);
                RootEditPart rep = dgrmEP.getRoot();
                if (rep instanceof DiagramRootEditPart) {
                    this.mapMode = ((DiagramRootEditPart)rep).getMapMode();
                }
                if ((preferenceStore = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore()).getBoolean("print.useWorkspaceSettings") && dgrmEP.getDiagramPreferencesHint().getPreferenceStore() != null) {
                    preferenceStore = (IPreferenceStore)dgrmEP.getDiagramPreferencesHint().getPreferenceStore();
                }
                this.doPrintDiagram(this.printService.createPrintJob(), dgrmEP, loadedPreferences, preferenceStore);
            }
        }
        finally {
            this.dispose();
            shell.dispose();
        }
    }

    private DiagramEditor getDiagramEditor(Diagram diagram) {
        DiagramEditor result = null;
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            DiagramEditor diagramEditor;
            if (!(obj instanceof DiagramEditor) || (diagramEditor = (DiagramEditor)obj).getDiagram() != diagram) continue;
            result = diagramEditor;
            break;
        }
        return result;
    }
}

