/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.dialect.AbstractRepresentationDialectServices;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.identifier.AbstractRepresentationElementIdentifier;
import org.eclipse.sirius.business.api.dialect.identifier.RepresentationElementIdentifier;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.metamodel.helper.ComponentizationHelper;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.business.internal.dialect.NotYetOpenedDiagramAdapter;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramInterpretedExpressionQuery;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.DiagramIdentifier;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.EdgeIdentifier;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.NodeContainerIdentifier;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.NodeIdentifier;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.NodeStyleIdentifier;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.CreateViewTask;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.NavigationTask;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.DiagramImportDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.Navigation;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.internal.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class DiagramDialectServices
extends AbstractRepresentationDialectServices {
    protected boolean isSupported(DRepresentation representation) {
        return representation instanceof DDiagram;
    }

    protected boolean isSupported(RepresentationDescription description) {
        return description instanceof DiagramDescription;
    }

    public boolean canCreate(EObject semantic, RepresentationDescription desc) {
        boolean result = false;
        if (semantic != null && this.isSupported(desc)) {
            DiagramDescription diagDesc = (DiagramDescription)desc;
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
            if (accessor != null) {
                result = this.checkDomainClass(accessor, semantic, diagDesc.getDomainClass());
                boolean needsToCheckSemanticElement = true;
                if (diagDesc.getInit() == null || diagDesc.getInit().getInitialOperation() == null || diagDesc.getInit().getInitialOperation().getFirstModelOperations() == null) {
                    needsToCheckSemanticElement = false;
                }
                if (needsToCheckSemanticElement) {
                    result = result && this.checkSemanticElementCanBeFilled(accessor, semantic);
                }
            }
            result = result && this.checkPrecondition(semantic, diagDesc.getPreconditionExpression());
        }
        return result;
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, IProgressMonitor monitor) {
        DiagramDescription diagDesc = (DiagramDescription)description;
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
        DDiagramSynchronizer sync = new DDiagramSynchronizer(interpreter, diagDesc, accessor);
        sync.initDiagram(name, semantic, monitor);
        return sync.getDiagram();
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        DRepresentation diagram = null;
        try {
            monitor.beginTask("Create diagram : " + name, 6);
            monitor.subTask("Create diagram : " + name);
            diagram = this.createRepresentation(name, semantic, description, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (diagram != null) {
                this.refresh(diagram, (IProgressMonitor)new SubProgressMonitor(monitor, 26));
                if (DisplayMode.NORMAL.equals((Object)DisplayServiceManager.INSTANCE.getMode())) {
                    DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)diagram);
                    monitor.worked(1);
                }
                session.getServices().putCustomData("DREPRESENTATION", semantic, (EObject)diagram);
                monitor.worked(1);
                Diagram gmfDiag = DiagramDialectServices.createAndStoreGMFDiagram(session, (DSemanticDiagram)diagram);
                monitor.worked(1);
                CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiag);
                canonicalSynchronizer.storeViewsToArrange(true);
                canonicalSynchronizer.synchronize();
                canonicalSynchronizer.postCreation();
                monitor.worked(10);
            }
        }
        finally {
            monitor.done();
        }
        return diagram;
    }

    public static Diagram createAndStoreGMFDiagram(Session session, DSemanticDiagram diagram) {
        Diagram gmfDiag;
        DiagramCreationUtil util = new DiagramCreationUtil(diagram);
        if (!util.findAssociatedGMFDiagram()) {
            util.createNewGMFDiagram();
        }
        if ((gmfDiag = util.getAssociatedGMFDiagram()) != null) {
            session.getServices().putCustomData("GMF_DIAGRAMS", (EObject)diagram, (EObject)gmfDiag);
        }
        NotYetOpenedDiagramAdapter.markAsToArrange(diagram);
        return gmfDiag;
    }

    public DRepresentation copyRepresentation(DRepresentation representation, String name, Session session, IProgressMonitor monitor) {
        DRepresentation newRepresentation = super.copyRepresentation(representation, name, session, monitor);
        session.getServices().putCustomData("DREPRESENTATION", ((DSemanticDecorator)representation).getTarget(), (EObject)newRepresentation);
        return newRepresentation;
    }

    public void refresh(DRepresentation representation, boolean fullRefresh, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refresh diagram", 10);
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            if (diagram.getDescription() != null) {
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)representation);
                ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
                DDiagramSynchronizer sync = new DDiagramSynchronizer(interpreter, diagram.getDescription(), accessor);
                sync.setDiagram(diagram);
                monitor.worked(1);
                sync.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 7));
                DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility(diagram);
                monitor.worked(1);
                NotificationUtil.sendNotification((EObject)diagram, (int)0, (int)5);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean deleteRepresentation(DRepresentation representation, Session session) {
        if (representation instanceof DDiagram) {
            session.getServices().clearCustomData("GMF_DIAGRAMS", (EObject)representation);
            SiriusUtil.delete((EObject)representation, (Session)session);
            return true;
        }
        return false;
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        if (representation instanceof DDiagram) {
            return ((DDiagram)representation).getDescription();
        }
        return null;
    }

    public void initRepresentations(Viewpoint vp, EObject semantic) {
        super.initRepresentations(semantic, vp, DiagramDescription.class);
    }

    public void initRepresentations(Viewpoint vp, EObject semantic, IProgressMonitor monitor) {
        super.initRepresentations(semantic, vp, DiagramDescription.class, monitor);
    }

    protected <T extends RepresentationDescription> void initRepresentationForElement(T representationDescription, EObject semanticElement, IProgressMonitor monitor) {
        TransactionalEditingDomain transactionalEditingDomain;
        DiagramDescription diagramDescription;
        if (representationDescription instanceof DiagramDescription && this.shouldInitializeRepresentation(semanticElement, diagramDescription = (DiagramDescription)representationDescription, diagramDescription.getDomainClass()) && DialectManager.INSTANCE.canCreate(semanticElement, (RepresentationDescription)diagramDescription) && (transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)semanticElement)) != null) {
            try {
                monitor.beginTask("Initialize diagram of type " + new IdentifiedElementQuery(representationDescription).getLabel(), 1);
                DCommand command = DiagramCommandFactoryService.getInstance().getNewProvider().getCommandFactory(transactionalEditingDomain).buildCreateDiagramFromDescription(diagramDescription, semanticElement, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                TransactionUtil.getEditingDomain((EObject)semanticElement).getCommandStack().execute((Command)command);
            }
            finally {
                monitor.done();
            }
        }
    }

    public boolean canCreateIdentifier(EObject representationElement) {
        return representationElement instanceof DDiagram || representationElement instanceof DDiagramElement || representationElement instanceof NodeStyle;
    }

    public RepresentationElementIdentifier createIdentifier(EObject representationElement, Map<EObject, RepresentationElementIdentifier> elementToIdentifier) {
        NodeStyle node;
        EObject container;
        RepresentationElementIdentifier containerIdentifier;
        AbstractRepresentationElementIdentifier identifier = null;
        if (representationElement instanceof DSemanticDiagram) {
            identifier = new DiagramIdentifier((DSemanticDiagram)representationElement);
        } else if (representationElement instanceof AbstractDNode) {
            AbstractDNode node2 = (AbstractDNode)representationElement;
            EObject container2 = node2.eContainer();
            RepresentationElementIdentifier containerIdentifier2 = this.getOrCreateIdentifier(container2, elementToIdentifier);
            if (containerIdentifier2 != null) {
                identifier = new NodeIdentifier(node2, (NodeContainerIdentifier)containerIdentifier2);
            }
        } else if (representationElement instanceof DEdge) {
            DEdge edge = (DEdge)representationElement;
            if (edge.getSourceNode() instanceof AbstractDNode && edge.getTargetNode() instanceof AbstractDNode) {
                AbstractDNode source = (AbstractDNode)((Object)edge.getSourceNode());
                AbstractDNode target = (AbstractDNode)((Object)edge.getTargetNode());
                RepresentationElementIdentifier sourceIdentifier = this.getOrCreateIdentifier((EObject)source, elementToIdentifier);
                RepresentationElementIdentifier targetIdentifier = this.getOrCreateIdentifier((EObject)target, elementToIdentifier);
                if (sourceIdentifier != null && targetIdentifier != null) {
                    identifier = new EdgeIdentifier(edge, (NodeIdentifier)sourceIdentifier, (NodeIdentifier)targetIdentifier);
                }
            }
        } else if (representationElement instanceof NodeStyle && (containerIdentifier = this.getOrCreateIdentifier(container = (node = (NodeStyle)representationElement).eContainer(), elementToIdentifier)) != null) {
            identifier = new NodeStyleIdentifier(node, (NodeIdentifier)containerIdentifier);
        }
        if (identifier != null) {
            elementToIdentifier.put(representationElement, (RepresentationElementIdentifier)identifier);
        }
        return identifier;
    }

    private RepresentationElementIdentifier getOrCreateIdentifier(EObject key, Map<EObject, RepresentationElementIdentifier> elementToIdentifier) {
        return elementToIdentifier.containsKey(key) ? elementToIdentifier.get(key) : this.createIdentifier(key, elementToIdentifier);
    }

    public void updateRepresentationsExtendedBy(Session session, Viewpoint viewpoint, boolean activated) {
        EList extensions = viewpoint.getOwnedRepresentationExtensions();
        for (DView view : session.getOwnedViews()) {
            for (DRepresentation representation : view.getAllRepresentations()) {
                if (!(representation instanceof DSemanticDiagram)) continue;
                for (RepresentationExtensionDescription ext : extensions) {
                    if (!ComponentizationHelper.extensionAppliesTo((RepresentationExtensionDescription)ext, (DRepresentation)representation) || !(ext instanceof DiagramExtensionDescription)) continue;
                    this.updateDiagram((DSemanticDiagram)representation, (DiagramExtensionDescription)ext, activated, session);
                }
            }
        }
    }

    private void updateDiagram(DSemanticDiagram diagram, DiagramExtensionDescription ext, boolean activated, Session session) {
        for (Layer layer : ext.getLayers()) {
            if (!(layer instanceof AdditionalLayer)) continue;
            AdditionalLayer additionalLayer = (AdditionalLayer)layer;
            Boolean shouldChangeLayerActivation = activated && !diagram.getActivatedLayers().contains((Object)additionalLayer);
            shouldChangeLayerActivation = shouldChangeLayerActivation != false || !activated && diagram.getActivatedLayers().contains((Object)additionalLayer);
            if (!(shouldChangeLayerActivation = Boolean.valueOf(shouldChangeLayerActivation != false && (!additionalLayer.isOptional() || additionalLayer.isActiveByDefault()))).booleanValue()) continue;
            new ChangeLayerActivationCommand(session.getTransactionalEditingDomain(), diagram, additionalLayer, (IProgressMonitor)new NullProgressMonitor()).execute();
        }
    }

    public IInterpretedExpressionQuery createInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        return new DiagramInterpretedExpressionQuery(target, feature);
    }

    public boolean handles(RepresentationDescription representationDescription) {
        return representationDescription instanceof DiagramDescription || representationDescription instanceof DiagramImportDescription;
    }

    public boolean handles(RepresentationExtensionDescription representationExtensionDescription) {
        return representationExtensionDescription instanceof DiagramExtensionDescription;
    }

    public void invalidateMappingCache() {
        DiagramDescriptionMappingsRegistry.INSTANCE.computeMappings();
    }

    public Option<? extends AbstractCommandTask> createTask(CommandContext context, ModelAccessor extPackage, ModelOperation op, Session session, UICallBack uiCallback) {
        Option task = Options.newNone();
        if (op instanceof CreateView) {
            CreateView createView = (CreateView)op;
            task = Options.newSome((Object)((Object)new CreateViewTask(context, extPackage, createView, session.getInterpreter())));
        } else if (op instanceof Navigation) {
            Navigation doubleClickNavigation = (Navigation)op;
            task = Options.newSome((Object)((Object)new NavigationTask(context, extPackage, doubleClickNavigation, session.getInterpreter(), uiCallback)));
        }
        return task;
    }

    public boolean allowsEStructuralFeatureCustomization(EObject element) {
        if (element instanceof StyleDescription || element.eContainer() instanceof StyleDescription) {
            EPackage ePackage = element.eClass().getEPackage();
            return ePackage == StylePackage.eINSTANCE || ePackage == org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE;
        }
        return false;
    }
}

