/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.primitives.Primitives;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.ConditionalStyleSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionKey;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.GetConditionalStyle;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.GetStyleDescription;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.query.EAttributeCustomizationQuery;
import org.eclipse.sirius.diagram.business.internal.query.StyleDescriptionQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.EAttributeCustomization;
import org.eclipse.sirius.viewpoint.description.EReferenceCustomization;
import org.eclipse.sirius.viewpoint.description.EStructuralFeatureCustomization;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class BestStyleDescriptionRegistry
extends HashMap<BestStyleDescriptionKey, StyleDescription> {
    public static final String DANNOTATION_CUSTOMIZATION_KEY = "DANNOTATION_CUSTOMIZATION_KEY";
    private static final long serialVersionUID = 1L;
    private IInterpreter interpreter;

    public BestStyleDescriptionRegistry(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public StyleDescription get(Object key) {
        BestStyleDescriptionKey bestStyleDescriptionKey;
        StyleDescription bestStyleDescription = (StyleDescription)super.get(key);
        if (bestStyleDescription == null && key instanceof BestStyleDescriptionKey && (bestStyleDescription = this.getBestStyleDescription(bestStyleDescriptionKey = (BestStyleDescriptionKey)key)) != null) {
            this.put(bestStyleDescriptionKey, bestStyleDescription);
        }
        return bestStyleDescription;
    }

    private StyleDescription getBestStyleDescription(BestStyleDescriptionKey bestStyleDescriptionKey) {
        StyleDescription result = null;
        DiagramElementMapping diagramElementMapping = bestStyleDescriptionKey.getDiagramElementMapping();
        DDiagram dDiagram = bestStyleDescriptionKey.getDDiagram();
        EObject modelElement = bestStyleDescriptionKey.getModelElement();
        EObject viewVariable = bestStyleDescriptionKey.getViewVariable();
        EObject containerVariable = bestStyleDescriptionKey.getContainerVariable();
        Iterator<? extends ConditionalStyleDescription> it = this.getConditionalStyles(diagramElementMapping, dDiagram).iterator();
        while (it.hasNext() && result == null) {
            ConditionalStyleDescription condStyle = it.next();
            if (!ConditionalStyleSpecOperations.checkPredicate(condStyle, modelElement, viewVariable, containerVariable, this.interpreter)) continue;
            result = this.getStyleDescription(condStyle);
        }
        if (result == null) {
            result = MappingHelper.getDefaultStyleDescription(diagramElementMapping);
        }
        if (result != null) {
            result = this.getCustomizedBestStyleDescription(result, bestStyleDescriptionKey);
        }
        return result;
    }

    private StyleDescription getCustomizedBestStyleDescription(StyleDescription styleDescription, BestStyleDescriptionKey bestStyleDescriptionKey) {
        StyleDescription customizedStyleDescription = styleDescription;
        StyleDescriptionQuery styleDescriptionQuery = new StyleDescriptionQuery(styleDescription);
        Map<EStructuralFeatureCustomization, Set<EObject>> eStructuralFeatureCustomizationAppliedOn = styleDescriptionQuery.getEStructuralFeatureCustomizationAppliedOn(bestStyleDescriptionKey, this.interpreter);
        if (!eStructuralFeatureCustomizationAppliedOn.isEmpty()) {
            customizedStyleDescription = (StyleDescription)EcoreUtil.copy((EObject)styleDescription);
            for (Map.Entry<EStructuralFeatureCustomization, Set<EObject>> entry : eStructuralFeatureCustomizationAppliedOn.entrySet()) {
                EStructuralFeatureCustomization featureCustomization = entry.getKey();
                Set<EObject> appliedOn = entry.getValue();
                if (featureCustomization instanceof EAttributeCustomization) {
                    EAttributeCustomization eAttributeCustomization = (EAttributeCustomization)featureCustomization;
                    this.applyEAttributeCustomization(eAttributeCustomization, styleDescription, customizedStyleDescription, appliedOn, bestStyleDescriptionKey);
                    continue;
                }
                if (!(featureCustomization instanceof EReferenceCustomization)) continue;
                EReferenceCustomization eReferenceCustomization = (EReferenceCustomization)featureCustomization;
                this.applyEReferenceCustomization(eReferenceCustomization, styleDescription, customizedStyleDescription, appliedOn);
            }
            customizedStyleDescription = this.storeInDDiagram(customizedStyleDescription, bestStyleDescriptionKey);
        } else {
            this.removeComputedStyleDescriptionFromCache(bestStyleDescriptionKey);
        }
        return customizedStyleDescription;
    }

    private StyleDescription storeInDDiagram(StyleDescription customizedStyleDescription, BestStyleDescriptionKey bestStyleDescriptionKey) {
        StyleDescription computedStyleDescriptionFromCache;
        EMap containerVariablesMap;
        EMap viewVariablesMap;
        DDiagram dDiagram = bestStyleDescriptionKey.getDDiagram();
        ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry = BestStyleDescriptionRegistry.getComputedStyleDescriptionRegistry(dDiagram, true);
        EMap modelElementsMap = (EMap)computedStyleDescriptionRegistry.getCache().get((Object)bestStyleDescriptionKey.getDiagramElementMapping());
        if (modelElementsMap == null) {
            modelElementsMap = new BasicEMap();
            computedStyleDescriptionRegistry.getCache().put((Object)bestStyleDescriptionKey.getDiagramElementMapping(), (Object)modelElementsMap);
            modelElementsMap = (EMap)computedStyleDescriptionRegistry.getCache().get((Object)bestStyleDescriptionKey.getDiagramElementMapping());
        }
        if ((viewVariablesMap = (EMap)modelElementsMap.get((Object)bestStyleDescriptionKey.getModelElement())) == null) {
            viewVariablesMap = new BasicEMap();
            modelElementsMap.put((Object)bestStyleDescriptionKey.getModelElement(), (Object)viewVariablesMap);
            viewVariablesMap = (EMap)modelElementsMap.get((Object)bestStyleDescriptionKey.getModelElement());
        }
        if ((containerVariablesMap = (EMap)viewVariablesMap.get((Object)bestStyleDescriptionKey.getViewVariable())) == null) {
            containerVariablesMap = new BasicEMap();
            viewVariablesMap.put((Object)bestStyleDescriptionKey.getViewVariable(), (Object)containerVariablesMap);
            containerVariablesMap = (EMap)viewVariablesMap.get((Object)bestStyleDescriptionKey.getViewVariable());
        }
        if ((computedStyleDescriptionFromCache = (StyleDescription)containerVariablesMap.get((Object)bestStyleDescriptionKey.getContainerVariable())) == null) {
            computedStyleDescriptionRegistry.getComputedStyleDescriptions().add((Object)customizedStyleDescription);
            containerVariablesMap.put((Object)bestStyleDescriptionKey.getContainerVariable(), (Object)customizedStyleDescription);
        } else if (!EcoreUtil.equals((EObject)computedStyleDescriptionFromCache, (EObject)customizedStyleDescription)) {
            computedStyleDescriptionRegistry.getComputedStyleDescriptions().remove((Object)computedStyleDescriptionFromCache);
            computedStyleDescriptionRegistry.getComputedStyleDescriptions().add((Object)customizedStyleDescription);
            containerVariablesMap.put((Object)bestStyleDescriptionKey.getContainerVariable(), (Object)customizedStyleDescription);
        } else {
            return computedStyleDescriptionFromCache;
        }
        return customizedStyleDescription;
    }

    public static ComputedStyleDescriptionRegistry getComputedStyleDescriptionRegistry(DDiagram dDiagram, boolean createIfNotExists) {
        ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry = null;
        AnnotationEntry annotationEntry = null;
        Collection annotationEntries = new DRepresentationQuery((DRepresentation)dDiagram).getAnnotation(DANNOTATION_CUSTOMIZATION_KEY);
        if (annotationEntries == null || annotationEntries.isEmpty()) {
            annotationEntry = DescriptionFactory.eINSTANCE.createAnnotationEntry();
            annotationEntry.setSource(DANNOTATION_CUSTOMIZATION_KEY);
            dDiagram.getOwnedAnnotationEntries().add((Object)annotationEntry);
        } else {
            annotationEntry = (AnnotationEntry)annotationEntries.iterator().next();
        }
        if (annotationEntry.getData() == null || !(annotationEntry.getData() instanceof ComputedStyleDescriptionRegistry)) {
            computedStyleDescriptionRegistry = DiagramFactory.eINSTANCE.createComputedStyleDescriptionRegistry();
            annotationEntry.setData((EObject)computedStyleDescriptionRegistry);
        } else {
            computedStyleDescriptionRegistry = (ComputedStyleDescriptionRegistry)annotationEntry.getData();
        }
        return computedStyleDescriptionRegistry;
    }

    private void removeComputedStyleDescriptionFromCache(BestStyleDescriptionKey bestStyleDescriptionKey) {
        AnnotationEntry annotationEntry;
        StyleDescription styleDescription = null;
        DDiagram dDiagram = bestStyleDescriptionKey.getDDiagram();
        Collection annotationEntries = new DRepresentationQuery((DRepresentation)dDiagram).getAnnotation(DANNOTATION_CUSTOMIZATION_KEY);
        if (annotationEntries != null && !annotationEntries.isEmpty() && (annotationEntry = (AnnotationEntry)annotationEntries.iterator().next()).getData() instanceof ComputedStyleDescriptionRegistry) {
            ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry = (ComputedStyleDescriptionRegistry)annotationEntry.getData();
            EMap modelElementsMap = (EMap)computedStyleDescriptionRegistry.getCache().get((Object)bestStyleDescriptionKey.getDiagramElementMapping());
            if (modelElementsMap != null) {
                EMap viewVariablesMap = (EMap)modelElementsMap.get((Object)bestStyleDescriptionKey.getModelElement());
                if (viewVariablesMap != null) {
                    EMap containerVariablesMap = (EMap)viewVariablesMap.get((Object)bestStyleDescriptionKey.getViewVariable());
                    if (containerVariablesMap != null) {
                        styleDescription = (StyleDescription)containerVariablesMap.get((Object)bestStyleDescriptionKey.getContainerVariable());
                        containerVariablesMap.remove((Object)bestStyleDescriptionKey.getContainerVariable());
                        if (containerVariablesMap.isEmpty()) {
                            viewVariablesMap.remove((Object)bestStyleDescriptionKey.getViewVariable());
                        }
                    }
                    if (viewVariablesMap.isEmpty()) {
                        modelElementsMap.remove((Object)bestStyleDescriptionKey.getModelElement());
                    }
                }
                if (modelElementsMap.isEmpty()) {
                    computedStyleDescriptionRegistry.getCache().remove((Object)bestStyleDescriptionKey.getDiagramElementMapping());
                }
            }
            if (styleDescription != null) {
                computedStyleDescriptionRegistry.getComputedStyleDescriptions().remove(styleDescription);
            }
        }
    }

    private void applyEAttributeCustomization(EAttributeCustomization eAttributeCustomization, StyleDescription styleDescription, StyleDescription customizedStyleDescription, Set<EObject> appliedOn, BestStyleDescriptionKey bestStyleDescriptionKey) {
        String attributeName = eAttributeCustomization.getAttributeName();
        Set<EObject> realEltsToCustomize = this.getRealElementsToCustomize(styleDescription, customizedStyleDescription, appliedOn, (EStructuralFeatureCustomization)eAttributeCustomization);
        if (!realEltsToCustomize.isEmpty()) {
            EAttributeCustomizationQuery eAttributeCustomizationQuery = new EAttributeCustomizationQuery(eAttributeCustomization);
            String newAttributeValue = eAttributeCustomizationQuery.getNewAttributeValue(bestStyleDescriptionKey, this.interpreter);
            for (EObject realEltToCustomize : realEltsToCustomize) {
                Object convertedObject;
                EStructuralFeature eStructuralFeature = realEltToCustomize.eClass().getEStructuralFeature(attributeName);
                if (!(eStructuralFeature instanceof EAttribute) || newAttributeValue == null) continue;
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                EDataType eAttributeType = eAttribute.getEAttributeType();
                Class instanceClass = eAttributeType.getInstanceClass();
                if (instanceClass.isPrimitive()) {
                    instanceClass = Primitives.wrap((Class)instanceClass);
                }
                if ((convertedObject = EcoreUtil.createFromString((EDataType)eAttributeType, (String)newAttributeValue)) == null || !instanceClass.isAssignableFrom(convertedObject.getClass())) continue;
                realEltToCustomize.eSet((EStructuralFeature)eAttribute, convertedObject);
            }
        }
    }

    private void applyEReferenceCustomization(EReferenceCustomization eReferenceCustomization, StyleDescription styleDescription, StyleDescription customizedStyleDescription, Set<EObject> appliedOn) {
        Set<EObject> realEltsToCustomize = this.getRealElementsToCustomize(styleDescription, customizedStyleDescription, appliedOn, (EStructuralFeatureCustomization)eReferenceCustomization);
        for (EObject realEltToCustomize : realEltsToCustomize) {
            EStructuralFeature eStructuralFeature = realEltToCustomize.eClass().getEStructuralFeature(eReferenceCustomization.getReferenceName());
            if (!(eStructuralFeature instanceof EReference)) continue;
            realEltToCustomize.eSet(eStructuralFeature, (Object)eReferenceCustomization.getValue());
        }
    }

    private Set<EObject> getRealElementsToCustomize(StyleDescription styleDescription, StyleDescription customizedStyleDescription, Set<EObject> appliedOn, EStructuralFeatureCustomization eStructuralFeatureCustomization) {
        LinkedHashSet<EObject> realEltsToCustomize = new LinkedHashSet<EObject>();
        if (appliedOn.contains(styleDescription) && this.hasFeatureName((EObject)styleDescription, eStructuralFeatureCustomization)) {
            realEltsToCustomize.add((EObject)customizedStyleDescription);
        }
        TreeIterator styleDescriptionContent = styleDescription.eAllContents();
        while (styleDescriptionContent.hasNext()) {
            EObject next = (EObject)styleDescriptionContent.next();
            if (!appliedOn.contains(next) || !this.hasFeatureName(next, eStructuralFeatureCustomization)) continue;
            Object object = customizedStyleDescription.eGet(next.eContainingFeature());
            if (object instanceof EObject) {
                realEltsToCustomize.add((EObject)object);
                continue;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            for (Object obj : list) {
                if (!(obj instanceof EObject)) continue;
                realEltsToCustomize.add((EObject)obj);
            }
        }
        return realEltsToCustomize;
    }

    private boolean hasFeatureName(EObject eObject, EStructuralFeatureCustomization eStructuralFeatureCustomization) {
        boolean hasFeatureName = false;
        if (eStructuralFeatureCustomization instanceof EAttributeCustomization) {
            EAttributeCustomization eAttributeCustomization = (EAttributeCustomization)eStructuralFeatureCustomization;
            String attributeName = eAttributeCustomization.getAttributeName();
            hasFeatureName = eObject.eClass().getEStructuralFeature(attributeName) instanceof EAttribute;
        } else if (eStructuralFeatureCustomization instanceof EReferenceCustomization) {
            EReferenceCustomization eReferenceCustomization = (EReferenceCustomization)eStructuralFeatureCustomization;
            String referenceName = eReferenceCustomization.getReferenceName();
            hasFeatureName = eObject.eClass().getEStructuralFeature(referenceName) instanceof EReference;
        }
        return hasFeatureName;
    }

    private List<? extends ConditionalStyleDescription> getConditionalStyles(DiagramElementMapping mapping, DDiagram diagram) {
        return (List)new GetConditionalStyle(diagram).doSwitch((EObject)mapping);
    }

    private StyleDescription getStyleDescription(ConditionalStyleDescription conditionalStyleDescription) {
        return (StyleDescription)new GetStyleDescription().doSwitch((EObject)conditionalStyleDescription);
    }
}

