/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.validation.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.tools.api.validation.constraint.RuleWrappingStatus;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.validation.ERROR_LEVEL;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationSet;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;

public abstract class AbstractDDiagramConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Collection<ValidationRule> failures;
        EObject objetTeste = ctx.getTarget();
        EMFEventType typeEvenement = ctx.getEventType();
        if (typeEvenement == EMFEventType.NULL && objetTeste instanceof DDiagramElement && (failures = this.getFailingRules((DDiagramElement)objetTeste)).size() > 0) {
            MultiStatus parentStatus = new MultiStatus("org.eclipse.sirius", this.getHighestStatusCode(failures), "Validation issues", null);
            for (ValidationRule failedRule : failures) {
                EObject target = objetTeste;
                if (failedRule instanceof SemanticValidationRule) {
                    target = ((DDiagramElement)objetTeste).getTarget();
                }
                ConstraintStatus emfStatus = (ConstraintStatus)ctx.createFailureStatus(new Object[]{failedRule.getMessage(target)});
                parentStatus.add((IStatus)new RuleWrappingStatus(emfStatus, failedRule));
            }
            return parentStatus;
        }
        return ctx.createSuccessStatus();
    }

    private int getHighestStatusCode(Collection<ValidationRule> rules) {
        int highestCode = 0;
        Iterator<ValidationRule> it = rules.iterator();
        while (it.hasNext() && highestCode < 4) {
            int currentCode = this.mapLevelToStatusCode(it.next().getLevel());
            if (currentCode <= highestCode) continue;
            highestCode = currentCode;
        }
        return highestCode;
    }

    private int mapLevelToStatusCode(ERROR_LEVEL level) {
        int code = 0;
        if (level == ERROR_LEVEL.ERROR_LITERAL) {
            code = 4;
        } else if (level == ERROR_LEVEL.WARNING_LITERAL) {
            code = 2;
        } else if (level == ERROR_LEVEL.INFO_LITERAL) {
            code = 1;
        }
        return code;
    }

    private Collection<ValidationRule> getFailingRules(DDiagramElement objetTeste) {
        ArrayList<ValidationRule> failingRules = new ArrayList<ValidationRule>();
        DDiagram diagram = objetTeste.getParentDiagram();
        if (diagram != null) {
            DiagramDescription desc;
            ValidationSet validationSet;
            if (diagram.getActivatedRules().size() > 0) {
                failingRules.addAll(this.getFaillingRulesFromCollection(objetTeste, diagram.getActivatedRules().iterator()));
            } else if (diagram.getDescription() != null && (validationSet = (desc = diagram.getDescription()).getValidationSet()) != null) {
                failingRules.addAll(this.getFaillingRulesFromCollection(objetTeste, validationSet.getAllRules().iterator()));
            }
            failingRules.addAll(this.checkRulesFromActivatedViewpoints(objetTeste, diagram));
        }
        return failingRules;
    }

    private Collection<ValidationRule> checkRulesFromActivatedViewpoints(DDiagramElement objetTeste, DDiagram diagram) {
        EObject semantic = objetTeste.getTarget();
        Object firstFailingRule = null;
        Session session = SessionManager.INSTANCE.getSession(semantic);
        if (session != null) {
            Iterator it = session.getSelectedViewpoints(false).iterator();
            while (it.hasNext() && firstFailingRule == null) {
                Viewpoint vp = (Viewpoint)it.next();
                if (vp.getValidationSet() == null) continue;
                return this.getFaillingRulesFromCollection(objetTeste, vp.getValidationSet().getAllRules().iterator());
            }
        }
        return Collections.emptyList();
    }

    private Collection<ValidationRule> getFaillingRulesFromCollection(DDiagramElement objetTeste, Iterator<ValidationRule> it) {
        ArrayList<ValidationRule> failingRules = new ArrayList<ValidationRule>();
        while (it.hasNext()) {
            DiagramElementMapping objMapping;
            ValidationRule rule = it.next();
            if (!this.isValid(rule)) continue;
            EObject semanticTargetElement = objetTeste.getTarget();
            if (rule instanceof SemanticValidationRule && ((SemanticValidationRule)rule).getTargetClass() != null && !StringUtil.isEmpty((String)((SemanticValidationRule)rule).getTargetClass().trim())) {
                if (!this.isSemanticElementToValidate(objetTeste, semanticTargetElement, ((SemanticValidationRule)rule).getTargetClass()) || rule.checkRule(semanticTargetElement)) continue;
                failingRules.add(rule);
                continue;
            }
            if (!(rule instanceof ViewValidationRule) || (objMapping = objetTeste.getDiagramElementMapping()) == null || !((ViewValidationRule)rule).getTargets().contains((Object)objMapping) || rule.checkRule((EObject)objetTeste)) continue;
            failingRules.add(rule);
        }
        return failingRules;
    }

    private boolean isSemanticElementToValidate(DDiagramElement objectToValidate, EObject semanticElement, String expectedClass) {
        boolean result = false;
        if (SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticElement).eInstanceOf(semanticElement, expectedClass)) {
            if (objectToValidate instanceof DEdge) {
                if (((DEdge)objectToValidate).getSourceNode() instanceof DSemanticDecorator && !semanticElement.equals(((DSemanticDecorator)((DEdge)objectToValidate).getSourceNode()).getTarget())) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    protected abstract boolean isValid(ValidationRule var1);
}

