/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import java.util.Set;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewer;

public class TreeUIUpdaterRunnable
implements Runnable {
    private DTreeViewer dTreeViewer;
    private Set<Object> toRefreshInViewer;
    private Object[] objectsToUpdateInViewer;
    private Set<DTreeItem> toExpand;
    private Set<DTreeItem> toCollapse;

    public TreeUIUpdaterRunnable(DTreeViewer dTreeViewer, Set<Object> toRefreshInViewer, Object[] objectsToUpdateInViewer, Set<DTreeItem> toExpand, Set<DTreeItem> toCollapse) {
        this.dTreeViewer = dTreeViewer;
        this.toRefreshInViewer = toRefreshInViewer;
        this.objectsToUpdateInViewer = objectsToUpdateInViewer;
        this.toExpand = toExpand;
        this.toCollapse = toCollapse;
    }

    @Override
    public void run() {
        if (this.dTreeViewer != null && this.dTreeViewer.getControl() != null && !this.dTreeViewer.getControl().isDisposed()) {
            for (DTreeItem itemtoExpand : this.toExpand) {
                DslCommonPlugin.PROFILER.startWork("Change the collapse state of a line of the SWT table");
                this.dTreeViewer.setExpandedState(itemtoExpand, true);
                DslCommonPlugin.PROFILER.stopWork("Change the collapse state of a line of the SWT table");
            }
            for (DTreeItem itemToCollapse : this.toCollapse) {
                DslCommonPlugin.PROFILER.startWork("Change the collapse state of a line of the SWT table");
                this.dTreeViewer.setExpandedState(itemToCollapse, false);
                DslCommonPlugin.PROFILER.stopWork("Change the collapse state of a line of the SWT table");
            }
            for (Object itemToRefresh : this.toRefreshInViewer) {
                DslCommonPlugin.PROFILER.startWork("Refresh a line of the SWT table");
                this.dTreeViewer.refresh(itemToRefresh, true);
                DslCommonPlugin.PROFILER.stopWork("Refresh a line of the SWT table");
            }
            DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
            this.dTreeViewer.update(this.objectsToUpdateInViewer, null);
            DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
        }
    }
}

