/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.api.interaction;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.query.DTreeItemQuery;
import org.eclipse.sirius.tree.business.api.query.TreeDescriptionQuery;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.DTreeRefresh;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;

public class DTreeItemUserInteraction {
    private DTreeItem item;
    private GlobalContext ctx;

    public DTreeItemUserInteraction(DTreeItem item, GlobalContext ctx) {
        this.item = item;
        this.ctx = ctx;
    }

    public void expand() {
        this.item.setExpanded(true);
        this.refreshContent();
    }

    public void expandAll() {
        this.expand();
        for (DTreeItem child : this.item.getOwnedTreeItems()) {
            new DTreeItemUserInteraction(child, this.ctx).expandAll();
        }
    }

    public void refreshContent() {
        SemanticPartitionInvalidator invalidator = new SemanticPartitionInvalidator();
        Option<DTree> parentTree = new DTreeItemQuery(this.item).getParentTree();
        if (parentTree.some()) {
            DTreeRefresh refresher = new DTreeRefresh(this.item, new TreeDescriptionQuery(((DTree)parentTree.get()).getDescription()).getAllDescendantMappings(), invalidator, this.ctx);
            refresher.refresh(false, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void directEdit(String newLabel) {
    }

    public void collapse() {
        this.item.setExpanded(false);
    }
}

