/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.description;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.VariableContainer;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;

public abstract class AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    protected static final String VARIABLES_ANNOTATION_SOURCE = "http://www.eclipse.org/sirius/interpreted/expression/variables";
    protected static final char TYPE_DEFINTION_SEPARATOR = '|';
    protected static final String VARIABLE_TYPE_KEY = "type";
    protected static final String DEFAULT_VARIABLE_TYPE = "ecore.EObject";
    protected EObject target;
    protected EStructuralFeature feature;
    protected Option<Collection<String>> targetDomainClass;
    protected Collection<EPackage> packagesToImport;
    protected Collection<String> dependencies;
    protected Map<String, String> availableVariables;
    protected IInterpretedExpressionTargetSwitch targetSwitch;

    public AbstractInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        this.target = target;
        this.feature = feature;
        this.initializeTargetSwitch();
    }

    protected abstract void initializeTargetSwitch();

    @Override
    public Option<Collection<String>> getTargetDomainClasses() {
        if (this.targetDomainClass == null) {
            this.targetDomainClass = this.targetSwitch.doSwitch(this.target, this.feature != null);
        }
        return this.targetDomainClass;
    }

    @Override
    public Collection<EPackage> getPackagesToImport() {
        if (this.packagesToImport == null) {
            this.packagesToImport = Sets.newLinkedHashSet();
            EObject representation = this.target.eContainer();
            while (representation != null && !(representation instanceof RepresentationDescription)) {
                representation = representation.eContainer();
            }
            if (representation != null) {
                if (((RepresentationDescription)representation).getMetamodel().isEmpty()) {
                    for (String nsURI : Sets.newLinkedHashSet((Iterable)EPackage.Registry.INSTANCE.keySet())) {
                        try {
                            this.packagesToImport.add(EPackage.Registry.INSTANCE.getEPackage(nsURI));
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    this.packagesToImport.addAll((Collection<EPackage>)((RepresentationDescription)representation).getMetamodel());
                }
            }
            this.packagesToImport.add((EPackage)EcorePackage.eINSTANCE);
            this.packagesToImport.add(ViewpointPackage.eINSTANCE);
            this.packagesToImport.add(DescriptionPackage.eINSTANCE);
            this.packagesToImport.add(ToolPackage.eINSTANCE);
            this.packagesToImport.add(ValidationPackage.eINSTANCE);
        }
        return this.packagesToImport;
    }

    @Override
    public Collection<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = Sets.newLinkedHashSet();
            if (this.target != null) {
                EObject vp = this.target;
                while (vp != null && !(vp instanceof Viewpoint)) {
                    vp = vp.eContainer();
                }
                if (vp != null) {
                    for (JavaExtension dep : ((Viewpoint)vp).getOwnedJavaExtensions()) {
                        if (StringUtil.isEmpty((String)dep.getQualifiedClassName())) continue;
                        this.dependencies.add(dep.getQualifiedClassName());
                    }
                }
            }
        }
        return this.dependencies;
    }

    @Override
    public Map<String, String> getAvailableVariables() {
        Option<EObject> toolContext;
        if (this.availableVariables == null) {
            this.availableVariables = Maps.newLinkedHashMap();
        }
        if ((toolContext = this.getToolContext()).some()) {
            this.collectContextualVariableDefinitions(this.availableVariables, (EObject)toolContext.get(), this.target);
        }
        this.collectLocalVariablesDefinitions();
        return this.availableVariables;
    }

    protected Option<EObject> getToolContext() {
        return new EObjectQuery(this.target).getFirstAncestorOfType(ToolPackage.eINSTANCE.getAbstractToolDescription());
    }

    private void collectLocalVariablesDefinitions() {
        EAnnotation varAnnotations = this.feature.getEAnnotation(VARIABLES_ANNOTATION_SOURCE);
        if (varAnnotations != null) {
            for (String varName : varAnnotations.getDetails().keySet()) {
                String doc = (String)varAnnotations.getDetails().get((Object)varName);
                String typeName = DEFAULT_VARIABLE_TYPE;
                if (doc != null && doc.indexOf(124) != -1) {
                    typeName = doc.substring(0, doc.indexOf(124)).trim();
                }
                this.availableVariables.put(varName, typeName);
            }
        }
    }

    private void collectContextualVariableDefinitions(Map<String, String> vars, EObject top, EObject bottom) {
        HashMap definitions = Maps.newHashMap();
        EObject context = bottom;
        do {
            this.appendAllLocalVariableDefinitions(definitions, context);
        } while ((context = context.eContainer()) != null && context != top.eContainer());
        for (String var : definitions.keySet()) {
            vars.put(var, (String)((List)definitions.get(var)).get(0));
        }
    }

    protected String getVariableTypeName(AbstractVariable var) {
        Preconditions.checkNotNull((Object)var);
        Preconditions.checkNotNull((Object)var.eContainingFeature());
        String typeName = DEFAULT_VARIABLE_TYPE;
        EAnnotation varAnnotation = var.eContainingFeature().getEAnnotation(VARIABLES_ANNOTATION_SOURCE);
        if (varAnnotation != null && varAnnotation.getDetails().containsKey((Object)VARIABLE_TYPE_KEY)) {
            typeName = (String)varAnnotation.getDetails().get((Object)VARIABLE_TYPE_KEY);
        }
        return typeName;
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<String>> definitions, EObject context) {
        if (context instanceof AbstractToolDescription) {
            for (AbstractVariable var : Iterables.filter((Iterable)AllContents.of((EObject)context, (boolean)false), AbstractVariable.class)) {
                this.addDefinition(definitions, var.getName(), this.getVariableTypeName(var));
            }
        }
        if (context instanceof VariableContainer) {
            for (AbstractVariable subVar : ((VariableContainer)context).getSubVariables()) {
                this.appendAllLocalVariableDefinitions(definitions, subVar);
            }
        }
        if (context instanceof AbstractVariable) {
            AbstractVariable var;
            var = (AbstractVariable)context;
            this.addDefinition(definitions, var.getName(), this.getVariableTypeName(var));
        }
        if (context instanceof CreateInstance) {
            CreateInstance ci = (CreateInstance)context;
            this.addDefinition(definitions, ci.getVariableName(), ci.getTypeName());
        }
        if (context instanceof For) {
            For f = (For)context;
            this.addDefinition(definitions, f.getIteratorName(), DEFAULT_VARIABLE_TYPE);
        }
    }

    protected void appendEditMaskVariables(EditMaskVariables mask, Map<String, Collection<String>> definitions) {
        Pattern p = Pattern.compile("\\{\\d\\}");
        Matcher m = p.matcher(mask.getMask());
        while (m.find()) {
            String group = m.group();
            String index = group.substring(1, group.length() - 1);
            this.addDefinition(definitions, index, "String");
            this.addDefinition(definitions, "arg" + index, "String");
        }
    }

    protected void addDefinition(Map<String, Collection<String>> definitions, String name, String value) {
        ArrayList defs = definitions.get(name);
        if (defs == null) {
            defs = Lists.newArrayList();
            definitions.put(name, defs);
        }
        defs.add(value);
    }
}

