/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.dialect.description;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.validation.RuleAudit;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.util.ValidationSwitch;

public class ValidationInterpretedExpressionTargetSwitch
extends ValidationSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected int featureID;
    private IInterpretedExpressionTargetSwitch globalSwitch;
    private int lastFeatureID;

    public ValidationInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultInterpretedExpressionTargetSwitch) {
        this.lastFeatureID = this.featureID = feature != null ? feature.getFeatureID() : -1;
        this.globalSwitch = defaultInterpretedExpressionTargetSwitch;
    }

    @Override
    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        LinkedHashSet targets = Sets.newLinkedHashSet();
        return Options.newSome((Object)targets);
    }

    @Override
    public Option<Collection<String>> caseRuleAudit(RuleAudit object) {
        Option<Collection<String>> result = null;
        switch (this.featureID) {
            case 0: {
                EObject validationRule = object.eContainer();
                while (validationRule != null && !(validationRule instanceof ValidationRule)) {
                    validationRule = validationRule.eContainer();
                }
                if (validationRule == null) break;
                result = this.globalSwitch.doSwitch(validationRule, false);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseSemanticValidationRule(SemanticValidationRule object) {
        Option result = null;
        switch (this.featureID) {
            case -1: 
            case 1: {
                ArrayList targets = Lists.newArrayList((Object[])new String[]{object.getTargetClass()});
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseViewValidationRule(ViewValidationRule object) {
        Option result = null;
        switch (this.featureID) {
            case -1: 
            case 1: {
                ArrayList targetTypes = Lists.newArrayList((Object[])new String[]{"diagram.DDiagramElement"});
                result = Options.newSome((Object)targetTypes);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseValidationFix(ValidationFix object) {
        Option<Collection<String>> result = null;
        EObject validationRule = object.eContainer();
        while (validationRule != null && !(validationRule instanceof ValidationRule)) {
            validationRule = validationRule.eContainer();
        }
        if (validationRule != null) {
            result = this.globalSwitch.doSwitch(validationRule, false);
        }
        return result;
    }

    public void setConsiderFeature(boolean considerFeature) {
        if (considerFeature) {
            this.featureID = this.lastFeatureID;
        } else {
            this.lastFeatureID = this.featureID;
            this.featureID = -1;
        }
    }
}

