/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.component.util;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PayloadMarkerAdapter
extends EContentAdapter {
    public static PayloadMarkerAdapter INSTANCE = new PayloadMarkerAdapter();
    private final List<FeatureAccess> accessLog = new ArrayList<FeatureAccess>();
    private final Multiset<String> uniqueContexts = ConcurrentHashMultiset.create();

    public static void install(EObject target) {
        for (Adapter a : target.eAdapters()) {
            if (!(a instanceof PayloadMarkerAdapter)) continue;
            return;
        }
        target.eAdapters().add((Object)INSTANCE);
    }

    public static boolean isPayload(EObject o) {
        return o != null && PayloadMarkerAdapter.getPayloadMarker(o) != null;
    }

    public static PayloadMarkerAdapter getPayloadMarker(EObject o) {
        for (Adapter a : o.eAdapters()) {
            if (!(a instanceof PayloadMarkerAdapter)) continue;
            return (PayloadMarkerAdapter)a;
        }
        return null;
    }

    public synchronized void logAccess(EStructuralFeature.Setting s) {
        String context = PayloadMarkerAdapter.computeContext();
        FeatureAccess fa = FeatureAccess.of(s, context);
        this.accessLog.add(fa);
        this.uniqueContexts.add((Object)context);
    }

    private static String computeContext() {
        Throwable e = new RuntimeException().fillInStackTrace();
        StackTraceElement[] stack = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        boolean tooDeep = false;
        int i = 0;
        while (i < stack.length) {
            StackTraceElement elt = stack[i];
            if (!tooDeep && elt.getClassName().equals("org.eclipse.swt.widgets.RunnableLock") && elt.getMethodName().equals("run") || elt.getClassName().equals("org.eclipse.core.runtime.SafeRunner") && elt.getMethodName().equals("run")) {
                tooDeep = true;
            }
            if (!tooDeep && !elt.getClassName().startsWith(PayloadMarkerAdapter.class.getName())) {
                sb.append(elt.toString()).append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public synchronized List<FeatureAccess> getAccessLog() {
        return Collections.unmodifiableList(new ArrayList<FeatureAccess>(this.accessLog));
    }

    public Multiset<String> getUniqueContexts() {
        return ImmutableMultiset.copyOf(this.uniqueContexts);
    }

    public synchronized void clearAccessLog() {
        this.accessLog.clear();
        this.uniqueContexts.clear();
    }

    public static class FeatureAccess {
        public final long timestamp;
        public final EStructuralFeature.Setting setting;
        public final String context;

        public static FeatureAccess of(EStructuralFeature.Setting s, String context) {
            return new FeatureAccess(System.currentTimeMillis(), s, context);
        }

        private FeatureAccess(long accessTimestamp, EStructuralFeature.Setting settingAccessed, String context) {
            this.timestamp = accessTimestamp;
            this.setting = settingAccessed;
            this.context = context;
        }

        public String toString() {
            return "Unexpected access to " + EcoreUtil.getURI((EObject)this.setting.getEObject()) + "->" + this.setting.getEStructuralFeature().getName();
        }
    }
}

