/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.EndOfLifeMoveOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.ShiftDirectSubExecutionsOperation;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ShiftDescendantMessagesOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.ExecutionSemanticEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.CreateMessageCreationValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusGraphicalNodeEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode2EditPart;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class InstanceRoleSiriusGraphicalNodeEditPolicy
extends SiriusGraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        TransactionalEditingDomain domain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        InstanceRoleEditPart host = (InstanceRoleEditPart)this.getHost();
        InstanceRole sequenceElement = host.getInstanceRole();
        SequenceDiagram sequenceDiagram = sequenceElement.getDiagram();
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (requestQuery.isCreateMessageCreation()) {
            CreateMessageCreationValidator validator = new CreateMessageCreationValidator();
            EditPart sourceEditPart = request.getSourceEditPart();
            EditPart targetEditPart = request.getTargetEditPart();
            Option lifelineSource = ((ISequenceElement)ISequenceElementAccessor.getISequenceElement((View)((View)sourceEditPart.getModel())).get()).getLifeline();
            Option lifelineTarget = ((ISequenceElement)ISequenceElementAccessor.getISequenceElement((View)((View)targetEditPart.getModel())).get()).getLifeline();
            InstanceRole instanceRoleSource = ((Lifeline)lifelineSource.get()).getInstanceRole();
            InstanceRole instanceRoleTarget = ((Lifeline)lifelineTarget.get()).getInstanceRole();
            validator.setSource((ISequenceElement)instanceRoleSource);
            validator.setTarget((ISequenceElement)instanceRoleTarget);
            Point firstClickLocation = SequenceEditPartsOperations.getConnectionSourceLocation(request, (IGraphicalEditPart)host);
            Point secondClickLocation = SequenceEditPartsOperations.getConnectionTargetLocation(request, (IGraphicalEditPart)host);
            if (!ExecutionSemanticEditPolicy.isCombinedFragmentTitleRangeEdgeCreation((ISequenceElement)sequenceElement, sequenceDiagram, firstClickLocation, firstClickLocation)) {
                validator.setFirstClickLocation(firstClickLocation);
                validator.setSecondClickLocation(secondClickLocation);
                if (validator.isValid(request)) {
                    result = super.getConnectionCompleteCommand(request);
                }
            }
        } else {
            result = super.getConnectionCompleteCommand(request);
            if (result != null && result.canExecute() && this.validateIsConnectingCreateMessage(request)) {
                CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(domain, "Move down lifeline/ add create participant message");
                Point sourceLocation = ((Point)ViewLocationHint.getInstance().getData((Object)"connection start")).getCopy();
                LifelineEditPart lep = EditPartsHelper.getAllLifelines((IGraphicalEditPart)this.getHost()).get(0);
                if (((AbstractGraphicalEditPart)this.getHost()).getTargetConnections().isEmpty() && this.validateIsNotCreateMessageToSelf(request) && this.validateNoEventBeforeCreate(sourceLocation, lep) && this.validateNotCreatingMessageInDifferentOperands(request, sourceLocation)) {
                    ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"move");
                    Rectangle bounds = ((AbstractGraphicalEditPart)this.getHost()).getFigure().getBounds();
                    Point scrollSize = GraphicalHelper.getScrollSize((GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
                    int yMoveNeeded = sourceLocation.y - bounds.y - bounds.height / 2 + scrollSize.y;
                    changeBoundsRequest.setMoveDelta(new Point(0, yMoveNeeded));
                    changeBoundsRequest.setConstrainedMove(true);
                    changeBoundsRequest.setEditParts(this.getHost());
                    ctc.compose((IUndoableOperation)new CommandProxy(this.getHost().getCommand((Request)changeBoundsRequest)));
                    ctc.compose((IUndoableOperation)new CommandProxy((Command)result));
                    int deltaY = changeBoundsRequest.getMoveDelta().y;
                    Lifeline lifeline = (Lifeline)lep.getISequenceEvent();
                    ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new EndOfLifeMoveOperation(lifeline, -deltaY)));
                    ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new ShiftDirectSubExecutionsOperation(lep.getISequenceEvent(), -deltaY)));
                    ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new ShiftDescendantMessagesOperation(lep.getISequenceEvent(), deltaY, true, false, true)));
                    SequenceEditPartsOperations.addRefreshSemanticOrderingCommand(ctc, (IGraphicalEditPart)this.getHost());
                    SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(ctc, (IGraphicalEditPart)this.getHost());
                } else {
                    result = UnexecutableCommand.INSTANCE;
                }
                result = new ICommandProxy((ICommand)ctc);
            }
        }
        return result;
    }

    private boolean validateIsConnectingCreateMessage(CreateConnectionRequest request) {
        boolean result = "connection end".equals(request.getType()) && request.getNewObject() instanceof MessageCreationTool;
        result = result && this.getHost().equals(request.getTargetEditPart()) && request.getSourceEditPart() instanceof DNode2EditPart;
        return result;
    }

    private boolean validateIsNotCreateMessageToSelf(CreateConnectionRequest request) {
        return EditPartsHelper.findParentLifeline((IGraphicalEditPart)request.getSourceEditPart()).getParent() != request.getTargetEditPart();
    }

    private boolean validateNotCreatingMessageInDifferentOperands(CreateConnectionRequest request, Point location) {
        boolean result = false;
        if (this.getHost() instanceof InstanceRoleEditPart && request.getSourceEditPart() instanceof ISequenceEventEditPart) {
            GraphicalHelper.screen2logical((Point)location, (IGraphicalEditPart)((InstanceRoleEditPart)this.getHost()));
            InstanceRoleEditPart targetEditPart = (InstanceRoleEditPart)this.getHost();
            Option targetParentOperand = targetEditPart.getInstanceRole().getLifeline().some() ? ((Lifeline)targetEditPart.getInstanceRole().getLifeline().get()).getParentOperand(location.y) : Options.newNone();
            ISequenceEventEditPart sourceEditPart = (ISequenceEventEditPart)request.getSourceEditPart();
            Option sourceParentOperand = sourceEditPart.getISequenceEvent() instanceof Lifeline ? ((Lifeline)sourceEditPart.getISequenceEvent()).getParentOperand(location.y) : sourceEditPart.getISequenceEvent().getParentOperand();
            result = targetParentOperand.some() ? sourceParentOperand.some() && ((Operand)targetParentOperand.get()).equals(sourceParentOperand.get()) : !sourceParentOperand.some();
        }
        return result;
    }

    private boolean validateNoEventBeforeCreate(final Point sourceLocation, LifelineEditPart lep) {
        ISequenceEvent lifeline = lep.getISequenceEvent();
        int firstEventInTargetInstanceRole = lifeline.getVerticalRange().getUpperBound();
        Predicate<ISequenceEvent> notParentCombinedFragment = new Predicate<ISequenceEvent>(){

            public boolean apply(ISequenceEvent input) {
                if (input instanceof CombinedFragment) {
                    CombinedFragment combinedFragment = (CombinedFragment)input;
                    return !combinedFragment.getVerticalRange().includes(sourceLocation.y);
                }
                return true;
            }
        };
        for (ISequenceEvent ise : Iterables.filter((Iterable)lifeline.getSubEvents(), (Predicate)notParentCombinedFragment)) {
            firstEventInTargetInstanceRole = Math.min(firstEventInTargetInstanceRole, ise.getVerticalRange().getLowerBound());
        }
        return sourceLocation.y < firstEventInTargetInstanceRole;
    }

    protected Command buildCreateEdgeCommand(CreateConnectionRequest request, EdgeTarget source, EdgeTarget target, EdgeCreationDescription edgeCreationDescription, IDiagramCommandFactoryProvider cmdFactoryProvider, EdgeLayoutData edgeLayoutData) {
        CompoundCommand result = new CompoundCommand();
        SequenceEditPartsOperations.appendFullRefresh((IGraphicalEditPart)this.getHost(), result);
        this.addStoreLayoutDataCommand(result, edgeLayoutData);
        SequenceEditPartsOperations.buildCreateEdgeCommand((IGraphicalEditPart)this.getHost(), result, request, source, target, edgeCreationDescription, cmdFactoryProvider);
        SequenceEditPartsOperations.appendFullRefresh((IGraphicalEditPart)this.getHost(), result);
        return result;
    }

    protected EdgeLayoutData getEdgeLayoutDataWithSnapToGrid(CreateConnectionRequest request, INodeEditPart sourceEditPart, INodeEditPart targetEditPart, Point sourceLocation, Point targetLocation) {
        return super.getEdgeLayoutData(request, sourceEditPart, targetEditPart, sourceLocation, targetLocation);
    }
}

