/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartRefreshVisualsOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ITransparentFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;

public final class DiagramBorderNodeEditPartOperation {
    private DiagramBorderNodeEditPartOperation() {
    }

    public static void refreshVisuals(IDiagramBorderNodeEditPart self) {
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DNode) {
            if (self.getPrimaryFigure() != null) {
                self.refreshFigure();
            }
            DiagramBorderNodeEditPartOperation.internalRefreshVisuals(self);
            if (self.getPrimaryFigure() != null) {
                self.refreshFigure();
                self.getPrimaryFigure().repaint();
            }
        }
    }

    public static void refreshFont(IDiagramBorderNodeEditPart self) {
        Object firstChild;
        if (!self.getChildren().isEmpty() && (firstChild = self.getChildren().get(0)) instanceof IDiagramNameEditPart) {
            DiagramNameEditPartOperation.refreshFont((IDiagramNameEditPart)firstChild);
        }
    }

    public static void internalRefreshVisuals(IDiagramBorderNodeEditPart self) {
        AbstractDiagramNodeEditPartRefreshVisualsOperation op = new AbstractDiagramNodeEditPartRefreshVisualsOperation(self);
        if (op.canRefresh()) {
            op.refreshSize();
        }
    }

    public static Object getStructuralFeatureValue(IGraphicalEditPart editPart, EStructuralFeature feature) {
        if (editPart.getNotationView() != null) {
            return ViewUtil.getPropertyValue((View)((View)editPart.getModel()), (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
        }
        return null;
    }

    public static void handleNotificationEvent(IDiagramBorderNodeEditPart self, Notification notification) {
        if (DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters().equals(notification.getFeature())) {
            if (notification.getNewValue() instanceof CollapseFilter && notification.getOldValue() == null) {
                DiagramBorderNodeEditPartOperation.updateCollapseMode(self, notification.getNotifier());
            } else if (notification.getOldValue() instanceof CollapseFilter && notification.getNewValue() == null) {
                DiagramBorderNodeEditPartOperation.updateCollapseMode(self, notification.getNotifier());
            }
        }
    }

    private static void updateCollapseMode(IDiagramBorderNodeEditPart self, Object notifier) {
        if (notifier != null && notifier.equals(self.resolveDiagramElement())) {
            DiagramBorderNodeEditPartOperation.updateResizeKind(self);
            StyledFigure styledFigure = DiagramElementEditPartOperation.getStyledFigure(self.getFigure());
            if (styledFigure instanceof ITransparentFigure) {
                DiagramBorderNodeEditPartOperation.updateTransparencyMode(self, (ITransparentFigure)((Object)styledFigure));
            }
        }
    }

    public static void updateTransparencyMode(IDiagramBorderNodeEditPart idbnep, ITransparentFigure figure) {
        DDiagramElement dde = idbnep.resolveDiagramElement();
        if (dde != null) {
            figure.setTransparent(new DDiagramElementQuery(dde).isIndirectlyCollapsed());
        }
    }

    public static void updateResizeKind(IDiagramBorderNodeEditPart self) {
        DDiagramElement dde = self.resolveDiagramElement();
        if (dde instanceof DNode) {
            DNode node = (DNode)dde;
            EditPolicy ep = self.getEditPolicy("PrimaryDrag Policy");
            if (ep instanceof ResizableEditPolicy) {
                DiagramBorderNodeEditPartOperation.updateResizeKind((ResizableEditPolicy)ep, node);
            }
        }
    }

    public static void updateResizeKind(ResizableEditPolicy ep, DNode node) {
        if (new DDiagramElementQuery((DDiagramElement)node).isIndirectlyCollapsed()) {
            ep.setResizeDirections(0);
        } else {
            DiagramNodeEditPartOperation.updateResizeKind(ep, node);
        }
    }

    public static void refreshFigure(IDiagramBorderNodeEditPart self) {
        StyledFigure styledFigure = DiagramElementEditPartOperation.getStyledFigure(self.getFigure());
        if (self.resolveDiagramElement() instanceof DNode) {
            DNode viewNode = (DNode)self.resolveDiagramElement();
            if (styledFigure != null) {
                if (((NodeStyle)viewNode.getStyle()).getLabelPosition() != null && ((NodeStyle)viewNode.getStyle()).getLabelPosition() == LabelPosition.NODE_LITERAL && !styledFigure.getChildren().contains((Object)self.getNodeLabel())) {
                    styledFigure.add((IFigure)self.getNodeLabel());
                }
                if (((NodeStyle)viewNode.getStyle()).getLabelPosition() != null && ((NodeStyle)viewNode.getStyle()).getLabelPosition() == LabelPosition.BORDER_LITERAL && styledFigure.getChildren().contains((Object)self.getNodeLabel())) {
                    styledFigure.remove((IFigure)self.getNodeLabel());
                }
                if (styledFigure.getChildren().contains((Object)self.getNodeLabel())) {
                    DiagramElementEditPartOperation.refreshFont(self, (EObject)viewNode, (IFigure)self.getNodeLabel());
                    self.getNodeLabel().setText(viewNode.getName());
                    self.getNodeLabel().setIcon(self.getLabelIcon());
                    StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(viewNode.getDiagramElementMapping(), viewNode.getStyle());
                    if (styleConfiguration != null) {
                        styleConfiguration.adaptNodeLabel(viewNode, self.getNodeLabel());
                    }
                }
                if (viewNode.getStyle() instanceof BorderedStyle) {
                    BorderedStyle borderedStyle = (BorderedStyle)viewNode.getStyle();
                    DiagramBorderNodeEditPartOperation.refreshBorderedStyle(styledFigure, borderedStyle);
                }
                self.setTooltipText(viewNode.getTooltipText());
                self.getNodeLabel().revalidate();
            }
        }
    }

    private static void refreshBorderedStyle(StyledFigure styledFigure, BorderedStyle borderedStyle) {
        if (borderedStyle.getBorderSize() == 0) {
            styledFigure.setBorder(null);
        } else {
            LineBorder lineBorder = null;
            if (styledFigure.getBorder() instanceof LineBorder) {
                lineBorder = (LineBorder)styledFigure.getBorder();
            } else {
                lineBorder = new LineBorder();
                styledFigure.setBorder((Border)lineBorder);
            }
            if (styledFigure instanceof Shape) {
                ((Shape)styledFigure).setLineWidth(0);
            }
            int borderSize = 0;
            if (borderedStyle.getBorderSize() != null) {
                borderSize = borderedStyle.getBorderSize();
            }
            lineBorder.setWidth(borderSize);
            if (borderedStyle.getBorderColor() != null) {
                lineBorder.setColor(VisualBindingManager.getDefault().getColorFromRGBValues(borderedStyle.getBorderColor()));
            }
            if (borderSize == 0) {
                styledFigure.setBorder(null);
            }
        }
    }

    protected static DefaultSizeNodeFigure getNodePlate(IDiagramBorderNodeEditPart viewNodeEditPart) {
        return AbstractDiagramNodeEditPartOperation.getNodePlate(viewNodeEditPart);
    }

    public static Command getResizeBorderItemCommand(IGraphicalEditPart part, ChangeBoundsRequest request) {
        return DiagramBorderNodeEditPartOperation.getResizeBorderItemCommand(part, request, true);
    }

    public static Command getResizeBorderItemCommand(IGraphicalEditPart part, ChangeBoundsRequest request, boolean forbidResizeIfCollapse) {
        ICommandProxy result;
        EObject semantic = part.resolveSemanticElement();
        if (semantic instanceof DNode) {
            boolean canResize;
            double zoom = ((ZoomManager)part.getViewer().getProperty(ZoomManager.class.toString())).getZoom();
            Dimension dimension = DiagramBorderNodeEditPartOperation.getDimensionFromView(part);
            Point position = DiagramBorderNodeEditPartOperation.getPositionFromView(part);
            DNode viewNode = (DNode)semantic;
            boolean bl = canResize = !new DDiagramElementQuery((DDiagramElement)viewNode).isIndirectlyCollapsed() || !forbidResizeIfCollapse;
            if (canResize && new DNodeQuery(viewNode).allowsVerticalResize()) {
                dimension.height = (int)((double)dimension.height + (double)request.getSizeDelta().height / zoom);
                switch (request.getResizeDirection()) {
                    case 1: 
                    case 9: 
                    case 17: {
                        position.y = (int)((double)position.y - (double)request.getSizeDelta().height / zoom);
                        break;
                    }
                }
            }
            if (canResize && new DNodeQuery(viewNode).allowsHorizontalResize()) {
                dimension.width = (int)((double)dimension.width + (double)request.getSizeDelta().width / zoom);
                switch (request.getResizeDirection()) {
                    case 8: 
                    case 9: 
                    case 12: {
                        position.x = (int)((double)position.x - (double)request.getSizeDelta().width / zoom);
                        break;
                    }
                }
            }
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(part.getEditingDomain(), "Resize", (IAdaptable)new EObjectAdapter((EObject)part.getNotationView()), new Rectangle(position, dimension));
            result = new ICommandProxy((ICommand)setBoundsCommand);
        } else {
            result = null;
        }
        return result;
    }

    private static Point getPositionFromView(IGraphicalEditPart part) {
        Point position = new Point();
        if (part.getNotationView() instanceof Node && ((Node)part.getNotationView()).getLayoutConstraint() instanceof Location) {
            Location location = (Location)((Node)part.getNotationView()).getLayoutConstraint();
            position.x = location.getX();
            position.y = location.getY();
        }
        return position;
    }

    private static Dimension getDimensionFromView(IGraphicalEditPart part) {
        Dimension dimension = new Dimension();
        if (part.getNotationView() instanceof Node && ((Node)part.getNotationView()).getLayoutConstraint() instanceof Size) {
            Size size = (Size)((Node)part.getNotationView()).getLayoutConstraint();
            dimension.width = size.getWidth();
            dimension.height = size.getHeight();
        }
        return dimension;
    }
}

