/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.RegionContainerResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.RegionResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.figures.SiriusLayoutHelper;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.ShiftEdgeIdentityAnchorOperation;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewSizeHint;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class AirXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    SiriusLayoutHelper layoutHelper;

    protected Command getCreateCommand(CreateRequest request) {
        Command cmd = null;
        if (!this.isNoteCreationRequest(request)) {
            if (this.isLocationUndefined(request.getLocation())) {
                cmd = this.buildCommand(request);
            } else {
                if (this.getHost() instanceof GraphicalEditPart) {
                    ((GraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)request.getLocation());
                }
                if (this.isLocationUndefined(request.getLocation())) {
                    cmd = this.buildCommand(request);
                }
            }
        }
        if (cmd == null) {
            cmd = super.getCreateCommand(request);
        }
        return cmd;
    }

    private boolean isNoteCreationRequest(CreateRequest request) {
        CreateViewRequest.ViewDescriptor desc;
        List viewDescriptors;
        return request instanceof CreateViewRequest && !(viewDescriptors = ((CreateViewRequest)request).getViewDescriptors()).isEmpty() && ViewType.NOTE.equals((desc = (CreateViewRequest.ViewDescriptor)viewDescriptors.get(0)).getSemanticHint());
    }

    private boolean isLocationUndefined(Point location) {
        if (LayoutHelper.UNDEFINED.getLocation().equals((Object)location)) {
            return true;
        }
        return location.x < 0 && location.y < 0;
    }

    private Command buildCommand(CreateRequest request) {
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        TransactionalEditingDomain editingDomain = host.getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        List viewDescriptors = ((CreateViewRequest)request).getViewDescriptors();
        Point locationReference = null;
        int i = 0;
        while (i < viewDescriptors.size()) {
            Object constraintFor;
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)viewDescriptors.get(i);
            viewDescriptor.setPersisted(true);
            Object object = this.getRealObject(viewDescriptor);
            Dimension size = null;
            Point location = null;
            boolean hasLayoutData = false;
            if (object instanceof DDiagramElement) {
                if (object instanceof AbstractDNode) {
                    LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData((AbstractDNode)object);
                    if (layoutData == null) {
                        layoutData = SiriusLayoutDataManager.INSTANCE.getData((AbstractDNode)object, true);
                    }
                    if (layoutData != null) {
                        size = layoutData.getSize();
                        location = layoutData.getLocation();
                        hasLayoutData = true;
                    }
                }
            } else {
                size = ViewSizeHint.getInstance().consumeSize();
            }
            if (size == null) {
                size = LayoutUtils.getDefaultDimension(viewDescriptor);
            }
            if (location == null && (constraintFor = this.getConstraintFor(request)) instanceof Rectangle) {
                location = ((Rectangle)constraintFor).getLocation().getCopy();
            }
            if (location != null) {
                Point centerLocation = location.getCopy();
                if (locationReference != null && !hasLayoutData) {
                    locationReference.translate(30, 30);
                    centerLocation = locationReference.getCopy();
                }
                Rectangle rect = new Rectangle(centerLocation, size);
                cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, rect));
                if (hasLayoutData || locationReference != null && viewDescriptors.size() > 1) {
                    cc.compose((IUndoableOperation)SiriusLayoutDataManager.INSTANCE.getAddAdapterMakerCommand(editingDomain, (IAdaptable)viewDescriptor));
                }
                if (hasLayoutData && i == 0) {
                    locationReference = location.getCopy();
                }
            }
            ++i;
        }
        if (cc.reduce() == null || cc.size() == 0) {
            return null;
        }
        CompoundCommand gefCompoundCmd = new CompoundCommand();
        gefCompoundCmd.add(this.chainGuideAttachmentCommands((Request)request, (Command)new ICommandProxy(cc.reduce())));
        return gefCompoundCmd;
    }

    private Object getRealObject(CreateViewRequest.ViewDescriptor viewDescriptor) {
        Object result = null;
        IAdaptable adapt = viewDescriptor.getElementAdapter();
        if (adapt instanceof Proxy) {
            result = ((Proxy)adapt).getRealObject();
        }
        return result;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        AirResizableEditPolicy childEditPolicy = new AirResizableEditPolicy();
        if (this.isRegionContainerCompartment(this.getHost())) {
            childEditPolicy = new RegionResizableEditPolicy();
        } else if (this.isRegionContainer(child)) {
            childEditPolicy = new RegionContainerResizableEditPolicy();
        }
        return childEditPolicy;
    }

    private boolean isRegionContainer(EditPart part) {
        if (part instanceof IDiagramContainerEditPart) {
            DDiagramElement element = ((IDiagramContainerEditPart)part).resolveDiagramElement();
            return this.isRegionContainer((EObject)element);
        }
        return false;
    }

    private boolean isRegionContainerCompartment(EditPart part) {
        if (part instanceof AbstractDNodeContainerCompartmentEditPart) {
            EObject element = ((AbstractDNodeContainerCompartmentEditPart)part).resolveSemanticElement();
            return this.isRegionContainer(element);
        }
        return false;
    }

    private boolean isRegionContainer(EObject element) {
        return element instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)element).isRegionContainer();
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        Rectangle result = super.getCurrentConstraintFor(child);
        if (result == null) {
            result = new Rectangle(0, 0, -1, -1);
        }
        return result;
    }

    protected Object getConstraintFor(CreateRequest request) {
        Object constraint = super.getConstraintFor(request);
        if (SiriusLayoutHelper.UNDEFINED.getLocation().equals((Object)request.getLocation())) {
            Rectangle rect = (Rectangle)constraint;
            rect.setLocation(this.getLayoutHelper().getReferencePosition(this.getHostFigure(), ((FigureCanvas)this.getHost().getViewer().getControl()).getViewport(), (IGraphicalEditPart)this.getHost()));
            Point point = this.getLayoutHelper().validatePosition(this.getHostFigure(), rect);
            rect.setLocation(point);
            return rect;
        }
        return constraint;
    }

    protected Object getConstraintFor(Request request, GraphicalEditPart child, Rectangle rect) {
        Object constraintFor = super.getConstraintFor(request, child, rect);
        if (constraintFor instanceof Rectangle && this.isRegionContainer((EditPart)child)) {
            Rectangle rectangle = (Rectangle)constraintFor;
            rectangle.setHeight(-1);
        }
        return constraintFor;
    }

    private SiriusLayoutHelper getLayoutHelper() {
        if (this.layoutHelper == null) {
            this.layoutHelper = new SiriusLayoutHelper();
        }
        return this.layoutHelper;
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        Command superCommand = super.getResizeChildrenCommand(request);
        EditPart host = this.getHost();
        if (host instanceof IGraphicalEditPart) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)host).getEditingDomain();
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, superCommand.getLabel());
            ctc.add((IUndoableOperation)new CommandProxy(superCommand));
            ShiftEdgeIdentityAnchorOperation operation = new ShiftEdgeIdentityAnchorOperation(request);
            ICommand command = CommandFactory.createICommand(editingDomain, operation);
            ctc.add((IUndoableOperation)command);
            return new ICommandProxy((ICommand)ctc);
        }
        return superCommand;
    }
}

