/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INotableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OneLineBorder;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.style.FlatContainerStyleDescription;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerDropPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeListViewNodeListCompartmentItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.canonicals.DumnySiriusCanonicalEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.operation.ComparisonHelper;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public abstract class AbstractDNodeListCompartmentEditPart
extends ListCompartmentEditPart
implements INotableEditPart,
ISurfaceEditPart,
ISiriusEditPart {
    private boolean isSupportingViewActions = false;

    public AbstractDNodeListCompartmentEditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeListViewNodeListCompartmentItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new SiriusContainerDropPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new DumnySiriusCanonicalEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new NodeCreationEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
    }

    public boolean isSupportingViewActions() {
        return this.isSupportingViewActions;
    }

    public void setIsSupportingViewActions(boolean supportsViewActions) {
        this.isSupportingViewActions = supportsViewActions;
    }

    protected boolean hasModelChildrenChanged(Notification evt) {
        return false;
    }

    public IFigure createFigure() {
        ResizableCompartmentFigure result = (ResizableCompartmentFigure)super.createFigure();
        result.setTitleVisibility(false);
        result.setToolTip(null);
        this.configureBorder(result);
        IFigure contentPane = result.getContentPane();
        if (contentPane != null && contentPane.getBorder() instanceof MarginBorder) {
            Insets insets = contentPane.getBorder().getInsets((IFigure)result);
            Insets legacyBorderCompensation = new Insets(0, -1, -1, -1);
            contentPane.setBorder((Border)new MarginBorder(insets.getAdded(legacyBorderCompensation)));
        }
        return result;
    }

    private void configureBorder(ResizableCompartmentFigure rcf) {
        if (this.hasLabelBorderStyle() || this.isLabelHidden()) {
            if (rcf.getBorder() instanceof LineBorder) {
                rcf.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(1), 0, 0, 0));
            }
        } else if (rcf.getBorder() instanceof MarginBorder) {
            rcf.setBorder((Border)new OneLineBorder(this.getMapMode().DPtoLP(1), 8));
        }
    }

    private boolean isLabelHidden() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagramElement) {
            return new DDiagramElementQuery((DDiagramElement)element).isLabelHidden();
        }
        return false;
    }

    private boolean hasLabelBorderStyle() {
        DDiagramElementContainer ddec;
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagramElementContainer && (ddec = (DDiagramElementContainer)element).getStyle() instanceof FlatContainerStyle && ddec.getStyle().getDescription() instanceof FlatContainerStyleDescription) {
            FlatContainerStyleDescription fcsd = (FlatContainerStyleDescription)ddec.getStyle().getDescription();
            return fcsd.getLabelBorderStyle() != null && !"labelBorderForContainer".equals(fcsd.getLabelBorderStyle().getId());
        }
        return false;
    }

    protected void refreshVisuals() {
        if (this.getFigure() instanceof ResizableCompartmentFigure) {
            ResizableCompartmentFigure rcf = (ResizableCompartmentFigure)this.getFigure();
            this.configureBorder(rcf);
        }
        super.refreshVisuals();
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent() != null && this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected List<?> getModelChildren() {
        ArrayList modelChildren = Lists.newArrayList((Iterable)super.getModelChildren());
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        new DNodeListElementComparisonHelper((DNodeList)this.resolveSemanticElement()).sort(modelChildren);
        return modelChildren;
    }

    public boolean canAttachNote() {
        return true;
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public List getPrimaryEditParts() {
        ArrayList<ConnectionEditPart> connections = new ArrayList<ConnectionEditPart>();
        Object diagramEditPart = this.getViewer().getEditPartRegistry().get(this.getDiagramView());
        List shapes = this.getChildren();
        HashSet connectableEditParts = new HashSet(shapes);
        Iterator iter = shapes.iterator();
        while (iter.hasNext()) {
            this.getBorderItemEditParts((EditPart)iter.next(), connectableEditParts);
        }
        if (diagramEditPart instanceof DiagramEditPart) {
            for (ConnectionEditPart connection : ((DiagramEditPart)diagramEditPart).getConnections()) {
                if (!connectableEditParts.contains(connection.getSource()) && !connectableEditParts.contains(connection.getTarget())) continue;
                connections.add(connection);
            }
        }
        if (connections.size() > 0 || shapes.size() > 0) {
            ArrayList<ConnectionEditPart> primaryEditParts = new ArrayList<ConnectionEditPart>();
            primaryEditParts.addAll(shapes);
            primaryEditParts.addAll(connections);
            return primaryEditParts;
        }
        return Collections.EMPTY_LIST;
    }

    private void getBorderItemEditParts(EditPart parent, Set retval) {
        for (EditPart child : parent.getChildren()) {
            if (child instanceof IBorderItemEditPart) {
                retval.add(child);
                retval.addAll(child.getChildren());
            }
            this.getBorderItemEditParts(child, retval);
        }
    }

    public void refresh() {
        super.refresh();
        Iterable children = Iterables.filter((Iterable)this.getChildren(), EditPart.class);
        for (EditPart childEditPart : children) {
            childEditPart.refresh();
        }
    }

    public Command getCommand(Request _request) {
        RequestQuery requestQuery = new RequestQuery(_request);
        if (requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest()) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(_request);
    }

    private static class DNodeListElementComparisonHelper
    extends ComparisonHelper {
        private DNodeList self;

        public DNodeListElementComparisonHelper(DNodeList self) {
            this.self = self;
        }

        @Override
        protected List<? extends DRepresentationElement> getDElementsToSort() {
            return this.self.getOwnedElements();
        }

        @Override
        protected List<? extends RepresentationElementMapping> getMappingsToSort() {
            return this.self.getActualMapping().getAllNodeMappings();
        }
    }
}

