/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.diagram.description.concern.provider.ConcernItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.filter.provider.FilterItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.style.provider.StyleItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.provider.DiagramItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.ui.business.internal.image.ImageSelectorDescriptorRegistryListener;
import org.eclipse.sirius.diagram.ui.business.internal.image.refresh.WorkspaceImageFigureRefresher;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.WorkspaceFileResourceChangeListener;
import org.eclipse.sirius.diagram.ui.provider.ImageWithDimensionDescriptor;
import org.eclipse.sirius.diagram.ui.provider.ImageWithDimensionDescriptorImpl;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.data.extension.LayoutDataManagerRegistryListener;
import org.eclipse.sirius.diagram.ui.tools.internal.resource.CustomSiriusDocumentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.resource.ResourceMissingDocumentProvider;
import org.eclipse.sirius.viewpoint.description.audit.provider.AuditItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.validation.provider.ValidationItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public final class DiagramUIPlugin
extends EMFPlugin {
    private static final String DECORATOR_CHECK_PATH = "icons/full/decorator/active.gif";
    public static final String ID = "org.eclipse.sirius.diagram.ui";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("org.eclipse.sirius.diagram.ui");
    public static final DiagramUIPlugin INSTANCE = new DiagramUIPlugin();
    private static Implementation plugin;

    public DiagramUIPlugin() {
        super(new ResourceLocator[]{EcoreEditPlugin.INSTANCE, SiriusEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private ComposedAdapterFactory adapterFactory;
        private ILabelProvider labelProvider;
        private Map<ImageWithDimensionDescriptor, Image> descriptorsToImages;
        private ResourceMissingDocumentProvider ressourceMissingDocumentProvider;
        private LayoutDataManagerRegistryListener layoutDataManagerRegistryListener;
        private ImageSelectorDescriptorRegistryListener imageSelectorDescriptorRegistryListener;
        private WorkspaceImageFigureRefresher workspaceImageFigureRefresher;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
            this.adapterFactory = this.createAdapterFactory();
            this.descriptorsToImages = new HashMap<ImageWithDimensionDescriptor, Image>();
            this.ressourceMissingDocumentProvider = new ResourceMissingDocumentProvider();
            this.workspaceImageFigureRefresher = new WorkspaceImageFigureRefresher();
            this.workspaceImageFigureRefresher.init();
            this.imageSelectorDescriptorRegistryListener = new ImageSelectorDescriptorRegistryListener();
            this.imageSelectorDescriptorRegistryListener.init();
            this.layoutDataManagerRegistryListener = new LayoutDataManagerRegistryListener();
            this.layoutDataManagerRegistryListener.init();
            UIJob job = new UIJob("InitSynchronizedCommand"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
                    Command command = commandService.getCommand("org.eclipse.sirius.diagram.ui.command.synchronizedDiagram");
                    command.isEnabled();
                    return new Status(0, DiagramUIPlugin.ID, "Init synchronized command performed succesfully");
                }
            };
            job.schedule();
        }

        public void stop(BundleContext context) throws Exception {
            try {
                this.disposeLabelProvider();
                this.adapterFactory.dispose();
                this.adapterFactory = null;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalStateException illegalStateException) {}
            this.layoutDataManagerRegistryListener.dispose();
            this.layoutDataManagerRegistryListener = null;
            this.workspaceImageFigureRefresher.dispose();
            this.workspaceImageFigureRefresher = null;
            this.imageSelectorDescriptorRegistryListener.dispose();
            this.imageSelectorDescriptorRegistryListener = null;
            for (Image img : this.descriptorsToImages.values()) {
                if (img == null) continue;
                img.dispose();
            }
            this.ressourceMissingDocumentProvider.dispose();
            WorkspaceFileResourceChangeListener.getInstance().dispose();
            super.stop(context);
        }

        protected void disposeLabelProvider() {
            if (this.labelProvider instanceof INotifyChangedListener) {
                this.adapterFactory.removeListener((INotifyChangedListener)this.labelProvider);
            }
        }

        protected ComposedAdapterFactory createAdapterFactory() {
            ArrayList<ComposedAdapterFactory> factories = new ArrayList<ComposedAdapterFactory>();
            factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            this.fillItemProviderFactories(factories);
            return new ComposedAdapterFactory(factories);
        }

        public ComposedAdapterFactory getNewAdapterFactory() {
            return this.createAdapterFactory();
        }

        protected ILabelProvider createLabelProvider() {
            if (this.labelProvider == null) {
                this.labelProvider = new AdapterFactoryLabelProvider(this.getItemProvidersAdapterFactory());
            }
            return this.labelProvider;
        }

        protected void fillItemProviderFactories(List factories) {
            factories.add(new ViewpointItemProviderAdapterFactory());
            factories.add(new DiagramItemProviderAdapterFactory());
            factories.add(new org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory());
            factories.add(new DescriptionItemProviderAdapterFactory());
            factories.add(new org.eclipse.sirius.viewpoint.description.style.provider.StyleItemProviderAdapterFactory());
            factories.add(new StyleItemProviderAdapterFactory());
            factories.add(new org.eclipse.sirius.viewpoint.description.tool.provider.ToolItemProviderAdapterFactory());
            factories.add(new ToolItemProviderAdapterFactory());
            factories.add(new AuditItemProviderAdapterFactory());
            factories.add(new ConcernItemProviderAdapterFactory());
            factories.add(new FilterItemProviderAdapterFactory());
            factories.add(new ValidationItemProviderAdapterFactory());
            factories.add(new EcoreItemProviderAdapterFactory());
            factories.add(new ResourceItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());
        }

        public AdapterFactory getItemProvidersAdapterFactory() {
            if (this.adapterFactory == null) {
                this.adapterFactory = this.createAdapterFactory();
            }
            return this.adapterFactory;
        }

        public ILabelProvider getLabelProvider() {
            if (this.labelProvider == null) {
                this.createLabelProvider();
            }
            return this.labelProvider;
        }

        public ImageDescriptor getItemImageDescriptor(Object item) {
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
            if (labelProvider != null) {
                return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
            }
            return null;
        }

        public static ImageDescriptor getBundledImageDescriptor(String path) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)DiagramUIPlugin.ID, (String)path);
        }

        public static ImageDescriptor getURLImageDescriptor(URL url) {
            return ImageDescriptor.createFromURL((URL)url);
        }

        public static ImageDescriptor findImageDescriptor(String path) {
            Path p = new Path(path);
            if (p.isAbsolute() && p.segmentCount() > 1) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
            }
            return Implementation.getBundledImageDescriptor(p.makeAbsolute().toString());
        }

        public static ImageWithDimensionDescriptor findImageWithDimensionDescriptor(String path, Dimension dimension) {
            ImageDescriptor desc = Implementation.findImageDescriptor(path);
            if (desc != null) {
                return new ImageWithDimensionDescriptorImpl(desc, dimension);
            }
            return null;
        }

        public static ImageWithDimensionDescriptor findImageWithDimensionDescriptor(String path) {
            return Implementation.findImageWithDimensionDescriptor(path, ImageWithDimensionDescriptor.NO_RESIZE);
        }

        public static ImageDescriptor findImageDescriptor(URL url) {
            return Implementation.getURLImageDescriptor(url);
        }

        public static ImageDescriptor getDecoratedCheckedImageDescriptor(ImageDescriptor imageDescriptor) {
            return Implementation.getDecoratedImageDescriptor(imageDescriptor, DiagramUIPlugin.DECORATOR_CHECK_PATH);
        }

        public static Image getDecoratedCheckedImage(ImageDescriptor imageDescriptor) {
            return Implementation.getDecoratedImage(imageDescriptor, DiagramUIPlugin.DECORATOR_CHECK_PATH);
        }

        public static ImageDescriptor getDecoratedImageDescriptor(ImageDescriptor imageDescriptor, String decoratorPath) {
            if (imageDescriptor != null) {
                return Implementation.getOverlayedDescriptor(DiagramUIPlugin.getPlugin().getImage(imageDescriptor), decoratorPath);
            }
            return imageDescriptor;
        }

        public static ImageDescriptor getDecoratedImageDescriptor(String imagePath, String decoratorPath) {
            return Implementation.getDecoratedImageDescriptor(Implementation.getBundledImageDescriptor(imagePath), decoratorPath);
        }

        public static Image getDecoratedImage(ImageDescriptor imageDescriptor, String decoratorPath) {
            Image image = DiagramUIPlugin.getPlugin().getImage(imageDescriptor);
            if (image != null) {
                return DiagramUIPlugin.getPlugin().getImage(Implementation.getOverlayedDescriptor(image, decoratorPath));
            }
            return image;
        }

        public static Image getDecoratedImage(Image image, String decoratorPath) {
            if (image != null) {
                return DiagramUIPlugin.getPlugin().getImage(Implementation.getOverlayedDescriptor(image, decoratorPath));
            }
            return image;
        }

        private static ImageDescriptor getOverlayedDescriptor(Image baseImage, String decoratorPath) {
            ImageDescriptor decoratorDescriptor = Implementation.getBundledImageDescriptor(decoratorPath);
            return new DecorationOverlayIcon(baseImage, decoratorDescriptor, 3);
        }

        public Image getBundledImage(String path) {
            Image image = this.getImageRegistry().get(path);
            if (image == null) {
                this.getImageRegistry().put(path, Implementation.getBundledImageDescriptor(path));
                image = this.getImageRegistry().get(path);
            }
            return image;
        }

        public Image getImage(ImageWithDimensionDescriptor desc) {
            if (!this.descriptorsToImages.containsKey(desc)) {
                ImageWithDimensionDescriptorImpl fullSizeDesc = new ImageWithDimensionDescriptorImpl(desc.getImageDescriptor());
                if (this.descriptorsToImages.containsKey(fullSizeDesc)) {
                    Image fullSize = this.descriptorsToImages.get(fullSizeDesc);
                    ImageDescriptor descToUse = ImageDescriptor.createFromImageData((ImageData)fullSize.getImageData().scaledTo(desc.getDimension().width, desc.getDimension().height));
                    this.descriptorsToImages.put(desc, descToUse.createImage());
                } else {
                    this.descriptorsToImages.put(fullSizeDesc, fullSizeDesc.getImageDescriptor().createImage());
                }
                return this.getImage(desc);
            }
            return this.descriptorsToImages.get(desc);
        }

        public Image getImage(ImageDescriptor desc) {
            ImageWithDimensionDescriptorImpl realDesc = new ImageWithDimensionDescriptorImpl(desc);
            if (!this.descriptorsToImages.containsKey(realDesc)) {
                this.descriptorsToImages.put(realDesc, desc.createImage());
            }
            return this.descriptorsToImages.get(realDesc);
        }

        public boolean removeCacheImage(ImageDescriptor desc) {
            ImageWithDimensionDescriptorImpl realDesc = new ImageWithDimensionDescriptorImpl(desc);
            return this.removeCacheImage(realDesc);
        }

        private boolean removeCacheImage(ImageWithDimensionDescriptor realDesc) {
            return this.descriptorsToImages.remove(realDesc) != null;
        }

        public ResourceMissingDocumentProvider getResourceMissingDocumentProvider() {
            return this.ressourceMissingDocumentProvider;
        }

        public CustomSiriusDocumentProvider getDocumentProvider(TransactionalEditingDomain transactionalEditingDomain) {
            return new CustomSiriusDocumentProvider(transactionalEditingDomain);
        }
    }
}

