/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AbstractCachedSVGFigure;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BundledImageFigure
extends AbstractCachedSVGFigure {
    private static final String SVG_STROKE = "stroke";
    private static final String SVG_FILL = "fill";
    private static final String SVG_STOP_COLOR = "stop-color";
    private static final String SVG_STYLE_ATTRIBUTE_NAME = "style";
    private static final String SVG_STOP_LIGHTER_ID = "stop1";
    private static final String SVG_STOP_MAIN_ID = "stop2";
    private static final String SVG_GRADIENT_ELEMENT_ID = "elementWithGradient";
    private static final String SVG_SHADOW_ELEMENT_ID = "shadow";
    private static final String IMAGE_DIR = "images/";
    private static final String IMAGE_EXT = ".svg";
    private String shapeName;
    private String mainBorderColor;
    private String lighterBorderColor;
    private String lighterGradientColor;
    private String mainGradientColor;

    public BundledImageFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    public static IFigure createImageFigure(BundledImage bundle) {
        BundledImageFigure fig = new BundledImageFigure();
        fig.refreshFigure(bundle);
        return fig;
    }

    private boolean updateShape(BundledImage bundledImage) {
        String newShapeName;
        boolean updated = false;
        if (bundledImage != null && bundledImage.getShape() != null && !StringUtil.isEmpty((String)(newShapeName = bundledImage.getShape().getName())) && !newShapeName.equals(this.getShapeName())) {
            this.setURI(BundledImageFigure.getImageFileURI(newShapeName), false);
            this.setShapeName(newShapeName);
            updated = true;
        }
        return updated;
    }

    private boolean updateColors(BundledImage bundledImage, boolean force) {
        boolean updated = this.updateColorFields(bundledImage);
        updated = this.updateDocumentColors(force || updated);
        return updated;
    }

    private boolean updateColorFields(BundledImage bundledImage) {
        RGBValues color = bundledImage.getColor();
        Color newLighterColor = ColorManager.getDefault().getLighterColor(color);
        RGBValues borderColor = bundledImage.getBorderColor();
        Color newBorderLighterColor = ColorManager.getDefault().getLighterColor(borderColor);
        String hexaColor = BundledImageFigure.getRGBValuesColorToHexa(color);
        String hexaLighterColor = this.getColorToHexa(newLighterColor);
        String hexaBorderColor = BundledImageFigure.getRGBValuesColorToHexa(borderColor);
        String hexaLighterBorderColor = this.getColorToHexa(newBorderLighterColor);
        boolean updated = false;
        if (hexaColor != null && !hexaColor.equals(this.getMainGradientColor())) {
            this.setMainGradientColor(hexaColor);
            updated = true;
        }
        if (hexaLighterColor != null && !hexaLighterColor.equals(this.getLighterGradientColor())) {
            this.setLighterGradientColor(hexaLighterColor);
            updated = true;
        }
        if (hexaBorderColor != null && !hexaBorderColor.equals(this.getMainBorderColor())) {
            this.setMainBorderColor(hexaBorderColor);
            updated = true;
        }
        if (hexaLighterBorderColor != null && !hexaLighterBorderColor.equals(this.getLighterBorderColor())) {
            this.setLighterBorderColor(hexaLighterBorderColor);
            updated = true;
        }
        return updated;
    }

    private boolean updateDocumentColors(boolean needsUpdate) {
        boolean updated = false;
        if (needsUpdate) {
            this.setURI(this.getURI(), false);
            Document document = this.getDocument();
            if (document != null && needsUpdate) {
                Element elementWithGradient;
                Element shadow;
                Element gradientStep2;
                Element gradientStep1 = document.getElementById(SVG_STOP_LIGHTER_ID);
                if (gradientStep1 != null) {
                    String gradientStep1Style = gradientStep1.getAttribute(SVG_STYLE_ATTRIBUTE_NAME);
                    gradientStep1.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(gradientStep1Style, SVG_STOP_COLOR, this.getLighterGradientColor()));
                    updated = true;
                }
                if ((gradientStep2 = document.getElementById(SVG_STOP_MAIN_ID)) != null) {
                    String gradientStep2Style = gradientStep2.getAttribute(SVG_STYLE_ATTRIBUTE_NAME);
                    gradientStep2.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(gradientStep2Style, SVG_STOP_COLOR, this.getMainGradientColor()));
                    updated = true;
                }
                if ((shadow = document.getElementById(SVG_SHADOW_ELEMENT_ID)) != null) {
                    String shadowStyle = shadow.getAttribute(SVG_STYLE_ATTRIBUTE_NAME);
                    shadow.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(shadowStyle, SVG_FILL, this.getLighterBorderColor()));
                    updated = true;
                }
                if ((elementWithGradient = document.getElementById(SVG_GRADIENT_ELEMENT_ID)) != null) {
                    String elementWithGradientStyle = elementWithGradient.getAttribute(SVG_STYLE_ATTRIBUTE_NAME);
                    elementWithGradient.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(elementWithGradientStyle, SVG_STROKE, this.getMainBorderColor()));
                    updated = true;
                }
            }
        }
        return updated;
    }

    private static String getImageFileURI(String shapeName) {
        String path = new StringBuffer(IMAGE_DIR).append(shapeName).append(IMAGE_EXT).toString();
        String pluginId = DiagramUIPlugin.getPlugin().getSymbolicName();
        return "platform:/plugin/" + pluginId + "/" + path;
    }

    private static String getRGBValuesColorToHexa(RGBValues color) {
        String blankDigit = "0";
        StringBuffer colorInHexa = new StringBuffer();
        String hexaColor = Integer.toHexString(color.getRed());
        if (hexaColor.length() == 1) {
            colorInHexa.append(blankDigit);
        }
        colorInHexa.append(hexaColor);
        hexaColor = Integer.toHexString(color.getGreen());
        if (hexaColor.length() == 1) {
            colorInHexa.append(blankDigit);
        }
        colorInHexa.append(hexaColor);
        hexaColor = Integer.toHexString(color.getBlue());
        if (hexaColor.length() == 1) {
            colorInHexa.append(blankDigit);
        }
        colorInHexa.append(hexaColor);
        return colorInHexa.toString();
    }

    private String getColorToHexa(Color color) {
        String blankDigit = "0";
        StringBuffer colorInHexa = new StringBuffer();
        String hexaColor = Integer.toHexString(color.getRed());
        if (hexaColor.length() == 1) {
            colorInHexa.append(blankDigit);
        }
        colorInHexa.append(hexaColor);
        hexaColor = Integer.toHexString(color.getGreen());
        if (hexaColor.length() == 1) {
            colorInHexa.append(blankDigit);
        }
        colorInHexa.append(hexaColor);
        hexaColor = Integer.toHexString(color.getBlue());
        if (hexaColor.length() == 1) {
            colorInHexa.append(blankDigit);
        }
        colorInHexa.append(hexaColor);
        return colorInHexa.toString();
    }

    private static String getNewStyle(String actualStyle, String colorAttribute, String newColor) {
        int indexOfColorAttribute = actualStyle.indexOf(colorAttribute);
        String newStyle = actualStyle.substring(0, indexOfColorAttribute + colorAttribute.length() + 2);
        newStyle = newStyle.concat(newColor);
        newStyle = newStyle.concat(actualStyle.substring(actualStyle.indexOf(";", indexOfColorAttribute), actualStyle.length()));
        return newStyle;
    }

    public void refreshFigure(BundledImage bundledImage) {
        if (bundledImage != null) {
            boolean updated = this.updateShape(bundledImage);
            boolean bl = updated = this.updateColors(bundledImage, updated) || updated;
            if (updated) {
                this.contentChanged();
            }
        } else {
            this.setURI(null);
        }
    }

    protected String getShapeName() {
        return this.shapeName;
    }

    protected void setShapeName(String shapeName) {
        this.shapeName = shapeName;
    }

    protected String getMainBorderColor() {
        return this.mainBorderColor;
    }

    protected void setMainBorderColor(String mainBorderColor) {
        this.mainBorderColor = mainBorderColor;
    }

    protected String getLighterBorderColor() {
        return this.lighterBorderColor;
    }

    protected void setLighterBorderColor(String lighterBorderColor) {
        this.lighterBorderColor = lighterBorderColor;
    }

    protected String getLighterGradientColor() {
        return this.lighterGradientColor;
    }

    protected void setLighterGradientColor(String lighterGradientColor) {
        this.lighterGradientColor = lighterGradientColor;
    }

    protected String getMainGradientColor() {
        return this.mainGradientColor;
    }

    protected void setMainGradientColor(String mainGradientColor) {
        this.mainGradientColor = mainGradientColor;
    }

    @Override
    protected String getKey() {
        StringBuffer result = new StringBuffer();
        result.append(this.getDocumentKey());
        result.append("|");
        result.append(this.getSiriusAlpha());
        result.append("|");
        return result.toString();
    }

    @Override
    protected String getDocumentKey() {
        StringBuffer result = new StringBuffer();
        result.append(super.getDocumentKey());
        result.append("|");
        result.append(this.shapeName);
        result.append("|");
        result.append(this.mainBorderColor);
        result.append("|");
        result.append(this.mainGradientColor);
        return result.toString();
    }
}

