/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.AutoSizeAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.CopyAppearancePropertiesAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.SizeBothAction;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.ui.tools.api.action.ConcernComboContributionItem;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.SelectHiddenElementsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.SelectPinnedElementsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.style.ResetStylePropertiesToDefaultValuesAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractTabbarFiller;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.FiltersContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.LayersContribution;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.LayoutingModeSwitchingAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.HideDDiagramElementLabelActionContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.TabbarAlignMenuManager;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.TabbarArrangeMenuManager;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.TabbarColorPropertyContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.TabbarSelectMenuManager;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.SiriusTabbarExtensionContributionFactory;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class TabbarFillerWithoutContributions
extends AbstractTabbarFiller {
    public TabbarFillerWithoutContributions(ToolBarManager manager, IWorkbenchPage page) {
        super(manager, page);
    }

    @Override
    protected void doFill() {
        this.createSelectArrangeAlignActions();
        this.manager.add((IContributionItem)new Separator());
        this.createLayerFilterActions();
        this.manager.add((IContributionItem)new Separator());
        this.createHideAndDeleteActions();
        this.createZoomActions();
        this.createExtraDiagramActions();
        this.manager.add((IContributionItem)new Separator());
        this.createStyleActions();
        this.manager.add((IContributionItem)new Separator());
        this.createSizeActions();
    }

    private void createSelectArrangeAlignActions() {
        TabbarArrangeMenuManager arrangeMenu = new TabbarArrangeMenuManager(this.part);
        arrangeMenu.setVisible(true);
        this.manager.add((IContributionItem)arrangeMenu);
        TabbarSelectMenuManager selectMenu = new TabbarSelectMenuManager();
        selectMenu.setVisible(true);
        this.manager.add((IContributionItem)selectMenu);
        TabbarAlignMenuManager alignMenu = new TabbarAlignMenuManager();
        alignMenu.setVisible(true);
        this.manager.add((IContributionItem)alignMenu);
    }

    private void createLayerFilterActions() {
        DiagramDescription description;
        DDiagram diagram;
        LayersContribution layersContribution = new LayersContribution();
        ContributionItem layerItem = layersContribution.createContributionItem(this.manager);
        layersContribution.setPart(this.part);
        this.manager.add((IContributionItem)layerItem);
        FiltersContributionItem filtersContribution = new FiltersContributionItem();
        ContributionItem filterItem = filtersContribution.createContributionItem(this.manager);
        filtersContribution.setPart(this.part);
        this.manager.add((IContributionItem)filterItem);
        if (this.part instanceof DDiagramEditor && (diagram = (DDiagram)((DDiagramEditor)this.part).getRepresentation()) != null && (description = diagram.getDescription()) != null && description.getConcerns() != null && description.getConcerns().getOwnedConcernDescriptions().size() > 1) {
            ConcernComboContributionItem item = new ConcernComboContributionItem((IPartService)this.page, "");
            item.setDiagram(diagram);
            this.manager.add((IContributionItem)item);
        }
    }

    private void createHideAndDeleteActions() {
        SelectHiddenElementsAction selectHiddenElementsAction = new SelectHiddenElementsAction(this.page, this.part);
        this.manager.add((IAction)selectHiddenElementsAction);
        HideDDiagramElementAction hideDDiagramElementAction = new HideDDiagramElementAction("Hide element");
        hideDDiagramElementAction.setActionPart((IWorkbenchPart)this.part);
        this.manager.add((IContributionItem)new SiriusTabbarExtensionContributionFactory.TabbarActionContributionItem((IAction)hideDDiagramElementAction, (IWorkbenchPart)this.part));
        HideDDiagramElementLabelActionContributionItem contributionItem = new HideDDiagramElementLabelActionContributionItem((IWorkbenchPart)this.part);
        this.manager.add((IContributionItem)contributionItem);
        SelectPinnedElementsAction pinnedElementsAction = new SelectPinnedElementsAction(this.page, (IWorkbenchPart)this.part);
        this.manager.add((IAction)pinnedElementsAction);
    }

    private void createZoomActions() {
        ZoomComboContributionItem zoomItem = new ZoomComboContributionItem((IPartService)this.page){

            public void fill(ToolBar parent, int index) {
                super.fill(parent, index);
                ToolItem addedItem = parent.getItem(parent.getItemCount() - 1);
                addedItem.setToolTipText(DiagramUIMessages.ZoomActionMenu_ZoomLabel);
            }
        };
        this.manager.add((IContributionItem)zoomItem);
    }

    private void createExtraDiagramActions() {
        DDiagram editorDiagram;
        if (this.part instanceof DDiagramEditor && LayoutingModeSwitchingAction.diagramAllowsLayoutingMode(editorDiagram = (DDiagram)((DDiagramEditor)this.part).getRepresentation())) {
            LayoutingModeSwitchingAction layoutingModeSwitchingAction = new LayoutingModeSwitchingAction(this.page, editorDiagram);
            this.manager.add((IContributionItem)new SiriusTabbarExtensionContributionFactory.TabbarActionContributionItem((IAction)layoutingModeSwitchingAction));
        }
    }

    private void createStyleActions() {
        TabbarColorPropertyContributionItem fontColorMenu = TabbarColorPropertyContributionItem.createFontColorContributionItem(this.page);
        fontColorMenu.setActionWorkbenchPart((IWorkbenchPart)this.part);
        this.manager.add((IContributionItem)fontColorMenu);
        TabbarColorPropertyContributionItem fillColorMenu = TabbarColorPropertyContributionItem.createFillColorContributionItem(this.page);
        fillColorMenu.setActionWorkbenchPart((IWorkbenchPart)this.part);
        this.manager.add((IContributionItem)fillColorMenu);
        TabbarColorPropertyContributionItem lineColorMenu = TabbarColorPropertyContributionItem.createLineColorContributionItem(this.page);
        lineColorMenu.setActionWorkbenchPart((IWorkbenchPart)this.part);
        this.manager.add((IContributionItem)lineColorMenu);
        ResetStylePropertiesToDefaultValuesAction resetStylePropertiesToDefaultValuesAction = new ResetStylePropertiesToDefaultValuesAction(this.page);
        this.manager.add((IContributionItem)new SiriusTabbarExtensionContributionFactory.TabbarActionContributionItem((IAction)resetStylePropertiesToDefaultValuesAction, (IWorkbenchPart)this.part));
        CopyAppearancePropertiesAction copyAppearancePropertiesAction = new CopyAppearancePropertiesAction(this.page);
        this.manager.add((IAction)copyAppearancePropertiesAction);
    }

    private void createSizeActions() {
        SizeBothAction sizeBothAction = new SizeBothAction(this.page);
        sizeBothAction.init();
        this.manager.add((IAction)sizeBothAction);
        AutoSizeAction autoSizeAction = new AutoSizeAction(this.page);
        this.manager.add((IAction)autoSizeAction);
    }
}

