/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.MappingFilter;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.FlatContainerStyleDescription;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;

public class ContainerMappingChildrenPresentationConstraints
extends AbstractConstraint {
    public static final String COMPARTMENT_CONTAINMENT_RULE_ID = "org.eclipse.sirius.diagram.constraints.CompartmentContainmentConstraint";
    public static final String REUSE_CONTAINERS_IN_CONTAINER_LIST_RULE_ID = "org.eclipse.sirius.diagram.constraints.ReuseContainersInContainerListConstraint";
    public static final String CONTAINERS_IN_CONTAINER_LIST_RULE_ID = "org.eclipse.sirius.diagram.constraints.ContainersInContainerListConstraint";
    public static final String REUSE_NODES_IN_REGION_CONTAINER_RULE_ID = "org.eclipse.sirius.diagram.constraints.NoReusedNodesInRegionContainerConstraint";
    public static final String REUSE_BORDERED_NODES_IN_REGION_CONTAINER_RULE_ID = "org.eclipse.sirius.diagram.constraints.NoReusedBorderedNodesInRegion";
    public static final String NODES_IN_REGION_CONTAINER_RULE_ID = "org.eclipse.sirius.diagram.constraints.NoSubNodesInRegionContainerConstraint";
    public static final String BORDERED_NODES_IN_REGION_CONTAINER_RULE_ID = "org.eclipse.sirius.diagram.constraints.NoBorderedNodesInRegion";
    public static final String MAPPING_FILTER_ON_REGION_MAPPING_RULE_ID = "org.eclipse.sirius.diagram.constraints.NoMappingFilterOnRegionsConstraint";
    public static final String REGION_REGION_CONTAINER_MAPPING_STYLE_RULE_ID = "org.eclipse.sirius.diagram.constraints.RegionStyleConstraint";
    public static final String REGION_MAPPING_CARDINALITY_RULE_ID = "org.eclipse.sirius.diagram.constraints.RegionMappingCardinalityConstraint";

    public IStatus validate(IValidationContext ctx) {
        IStatus result = ctx.createSuccessStatus();
        EObject eObj = ctx.getTarget();
        if (eObj instanceof ContainerMapping) {
            ContainerMapping containerMapping = (ContainerMapping)eObj;
            if (REGION_MAPPING_CARDINALITY_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                result = this.validateRegionMappingCardinality(ctx, containerMapping);
            } else if (COMPARTMENT_CONTAINMENT_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                result = this.validateCompartmentContainment(ctx, containerMapping);
            } else if (REUSE_CONTAINERS_IN_CONTAINER_LIST_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                result = this.validateReusedContainersInContainerList(ctx, containerMapping);
            } else if (CONTAINERS_IN_CONTAINER_LIST_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                result = this.validateContainersInContainerList(ctx, containerMapping);
            } else if (REUSE_NODES_IN_REGION_CONTAINER_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                result = this.validateReusedSubNodesInRegionContainer(ctx, containerMapping);
            } else if (REUSE_BORDERED_NODES_IN_REGION_CONTAINER_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                result = this.validateReusedBorderedNodesInRegion(ctx, containerMapping);
            }
        } else if (eObj instanceof NodeMapping) {
            NodeMapping currentMapping = (NodeMapping)eObj;
            if (currentMapping.eContainer() instanceof ContainerMapping) {
                ContainerMapping parentMapping = (ContainerMapping)currentMapping.eContainer();
                EStructuralFeature eContainingFeature = currentMapping.eContainingFeature();
                if (DescriptionPackage.eINSTANCE.getContainerMapping_SubNodeMappings().equals(eContainingFeature) && NODES_IN_REGION_CONTAINER_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                    result = this.validateSubNodesInRegionContainer(ctx, currentMapping, parentMapping);
                } else if (DescriptionPackage.eINSTANCE.getAbstractNodeMapping_BorderedNodeMappings().equals(eContainingFeature) && BORDERED_NODES_IN_REGION_CONTAINER_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                    result = this.validateBorderedNodesInRegion(ctx, currentMapping, parentMapping);
                }
            }
        } else if (eObj instanceof MappingFilter && MAPPING_FILTER_ON_REGION_MAPPING_RULE_ID.equals(ctx.getCurrentConstraintId())) {
            result = this.validateMappingFilterOnRegions(ctx, (MappingFilter)eObj);
        } else if (eObj instanceof ContainerStyleDescription) {
            Option parentContainerMapping = new EObjectQuery(eObj).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getContainerMapping());
            if (REGION_REGION_CONTAINER_MAPPING_STYLE_RULE_ID.equals(ctx.getCurrentConstraintId()) && parentContainerMapping.some()) {
                result = this.validateStyle(ctx, (ContainerStyleDescription)eObj, (ContainerMapping)parentContainerMapping.get());
            }
        }
        return result;
    }

    private IStatus validateRegionMappingCardinality(IValidationContext ctx, ContainerMapping containerMapping) {
        if (new ContainerMappingQuery(containerMapping).isRegionContainer() && containerMapping.getAllContainerMappings().isEmpty()) {
            return ctx.createFailureStatus(new Object[]{containerMapping});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateCompartmentContainment(IValidationContext ctx, ContainerMapping containerMapping) {
        ContainerMappingQuery query = new ContainerMappingQuery(containerMapping);
        if (query.isRegionContainer() && query.isRegion()) {
            return ctx.createFailureStatus(new Object[]{containerMapping});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateReusedContainersInContainerList(IValidationContext ctx, ContainerMapping containerMapping) {
        if (new ContainerMappingQuery(containerMapping).isListContainer() && !containerMapping.getReusedContainerMappings().isEmpty()) {
            return ctx.createFailureStatus(new Object[]{containerMapping.getReusedContainerMappings()});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateContainersInContainerList(IValidationContext ctx, ContainerMapping containerMapping) {
        EObject parentMapping = containerMapping.eContainer();
        if (parentMapping instanceof ContainerMapping && new ContainerMappingQuery((ContainerMapping)parentMapping).isListContainer()) {
            return ctx.createFailureStatus(new Object[]{containerMapping});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateReusedSubNodesInRegionContainer(IValidationContext ctx, ContainerMapping containerMapping) {
        if (new ContainerMappingQuery(containerMapping).isRegionContainer() && !containerMapping.getReusedNodeMappings().isEmpty()) {
            return ctx.createFailureStatus(new Object[]{containerMapping});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateReusedBorderedNodesInRegion(IValidationContext ctx, ContainerMapping containerMapping) {
        if (new ContainerMappingQuery(containerMapping).isRegion() && !containerMapping.getReusedBorderedNodeMappings().isEmpty()) {
            return ctx.createFailureStatus(new Object[]{containerMapping.getReusedBorderedNodeMappings()});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateSubNodesInRegionContainer(IValidationContext ctx, NodeMapping nodeMapping, ContainerMapping parentMapping) {
        if (new ContainerMappingQuery(parentMapping).isRegionContainer()) {
            return ctx.createFailureStatus(new Object[]{nodeMapping});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateBorderedNodesInRegion(IValidationContext ctx, NodeMapping nodeMapping, ContainerMapping parentMapping) {
        if (new ContainerMappingQuery(parentMapping).isRegion()) {
            return ctx.createFailureStatus(new Object[]{nodeMapping});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateMappingFilterOnRegions(IValidationContext ctx, MappingFilter filter) {
        for (DiagramElementMapping mapping : filter.getMappings()) {
            if (!(mapping instanceof ContainerMapping) || !new ContainerMappingQuery((ContainerMapping)mapping.eContainer()).isRegionContainer()) continue;
            return ctx.createFailureStatus(new Object[]{filter});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateStyle(IValidationContext ctx, ContainerStyleDescription style, ContainerMapping containerMapping) {
        ContainerMappingQuery query = new ContainerMappingQuery(containerMapping);
        if (!(style instanceof FlatContainerStyleDescription) && (query.isRegionContainer() || query.isRegion())) {
            return ctx.createFailureStatus(new Object[]{style, containerMapping});
        }
        return ctx.createSuccessStatus();
    }
}

