/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.business.api.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.business.api.query.DTableQuery;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.ui.business.api.helper.TableFiller;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public final class TableUIHelper {
    private TableUIHelper() {
    }

    protected static List<List<String>> toTableDescriptor(DTable table, boolean inverse, TableFiller filler) {
        ArrayList<List<String>> expected = new ArrayList<List<String>>();
        if (!inverse) {
            ArrayList<String> header = new ArrayList<String>();
            header.add("");
            for (DColumn column : table.getColumns()) {
                if (!column.isVisible()) continue;
                header.add(filler.getContent(column));
            }
            expected.add(header);
            for (DLine line : table.getLines()) {
                if (!line.isVisible()) continue;
                TableUIHelper.addLineToDescriptor(filler, expected, line);
            }
        } else {
            ArrayList<String> header = new ArrayList<String>();
            header.add("");
            for (DLine line : table.getLines()) {
                if (!line.isVisible()) continue;
                header.add(filler.getContent(line));
            }
            expected.add(header);
            for (DColumn column : table.getColumns()) {
                if (!column.isVisible()) continue;
                ArrayList<String> listColumn = new ArrayList<String>();
                listColumn.add(filler.getContent(column));
                for (DLine line : new DTableQuery(TableHelper.getTable((EObject)column)).getAllLines()) {
                    if (!line.isVisible()) continue;
                    Option optionalCell = TableHelper.getCell((DLine)line, (DColumn)column);
                    if (optionalCell.some()) {
                        listColumn.add(filler.getContent((DCell)optionalCell.get()));
                        continue;
                    }
                    listColumn.add("_");
                }
                expected.add(listColumn);
            }
        }
        return expected;
    }

    protected static List<List<String>> toTableDescriptor(Tree tree, TableFiller filler) {
        ArrayList<List<String>> expected = new ArrayList<List<String>>();
        ArrayList<String> header = new ArrayList<String>();
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            header.add(filler.getContent(treeColumn));
            ++n2;
        }
        expected.add(header);
        treeColumnArray = tree.getItems();
        n = treeColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            TreeColumn treeItem = treeColumnArray[n2];
            TableUIHelper.addLineToDescriptor(filler, expected, (TreeItem)treeItem);
            ++n2;
        }
        return expected;
    }

    private static void addLineToDescriptor(TableFiller filler, List<List<String>> expected, DLine line) {
        ArrayList<String> listLine = new ArrayList<String>();
        listLine.add(filler.getContent(line));
        DTable parentTable = TableHelper.getTable((EObject)line);
        for (DColumn column : parentTable.getColumns()) {
            if (!column.isVisible()) continue;
            Option optionalCell = TableHelper.getCell((DLine)line, (DColumn)column);
            if (optionalCell.some()) {
                listLine.add(filler.getContent((DCell)optionalCell.get()));
                continue;
            }
            listLine.add(filler.getContent(line, column));
        }
        expected.add(listLine);
        for (DLine subLine : line.getLines()) {
            TableUIHelper.addLineToDescriptor(filler, expected, subLine);
        }
    }

    private static void addLineToDescriptor(TableFiller filler, List<List<String>> expected, TreeItem treeItem) {
        if (treeItem.getExpanded() || treeItem.getItemCount() == 0) {
            ArrayList<String> listLine = new ArrayList<String>();
            int i = 0;
            while (i < treeItem.getParent().getColumnCount()) {
                listLine.add(filler.getContent(treeItem, i));
                ++i;
            }
            expected.add(listLine);
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem subTreeItem = treeItemArray[n2];
                TableUIHelper.addLineToDescriptor(filler, expected, subTreeItem);
                ++n2;
            }
        }
    }

    public static String toContentHTMl(DTable table, boolean inverse) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(table, inverse, new TableFiller()));
    }

    public static String toContentHTMl(Tree tree) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(tree, new TableFiller()));
    }

    public static String toHTML(List<List<String>> descriptor) {
        List<String> line;
        int nbColumnMax = -1;
        int i = 0;
        while (i < descriptor.size()) {
            line = descriptor.get(i);
            if (line.size() > nbColumnMax) {
                nbColumnMax = line.size();
            }
            ++i;
        }
        int[] columnMaxSize = new int[nbColumnMax];
        i = 0;
        while (i < nbColumnMax) {
            columnMaxSize[i] = -1;
            ++i;
        }
        i = 0;
        while (i < descriptor.size()) {
            line = descriptor.get(i);
            int j = 0;
            while (j < line.size()) {
                if (line.get(j).length() > columnMaxSize[j]) {
                    columnMaxSize[j] = line.get(j).length();
                }
                ++j;
            }
            ++i;
        }
        StringBuffer result = new StringBuffer();
        result.append("<table>\n");
        int i2 = 0;
        while (i2 < descriptor.size()) {
            List<String> line2 = descriptor.get(i2);
            result.append("<tr>");
            for (String column : line2) {
                if (i2 == 0) {
                    result.append("<th>");
                } else {
                    result.append("<td>");
                }
                StringBuffer textToAppend = new StringBuffer();
                int charsToAdd = columnMaxSize[line2.indexOf(column)] - column.length();
                int c = 0;
                while (c < charsToAdd) {
                    textToAppend.append("_");
                    ++c;
                }
                result.append(column);
                result.append(textToAppend);
                if (i2 == 0) {
                    result.append("</th>");
                    continue;
                }
                result.append("</td>");
            }
            result.append("</tr>\n");
            ++i2;
        }
        result.append("</table>");
        return result.toString();
    }

    public static void addLineToTable(List<List<String>> expected, String[] strings) {
        expected.add(Arrays.asList(strings));
    }

    public static String toForegroundStyleHTMl(DTable table, boolean inverse) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(table, inverse, new TableFiller(){

            @Override
            public String getContent(DCell cell) {
                return TableUIHelper.getForegroundStyleName((Option<DTableElementStyle>)new DCellQuery(cell).getForegroundStyleToApply());
            }
        }));
    }

    public static String toForegroundStyleHTMl(Tree tree) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(tree, new TableFiller(){

            @Override
            public String getContent(TreeItem treeItem, int index) {
                String result = "_";
                String text = treeItem.getText(index);
                if (index == 0) {
                    result = text;
                } else if (!this.isCellExist(treeItem, index - 1)) {
                    Color foregroundColor = treeItem.getForeground(index);
                    RGBValues newRGB = RGBValues.create((int)foregroundColor.getRed(), (int)foregroundColor.getGreen(), (int)foregroundColor.getBlue());
                    result = TableUIHelper.getColorName(newRGB);
                }
                return result;
            }

            private boolean isCellExist(TreeItem treeItem, int index) {
                if (treeItem.getData() instanceof DLine) {
                    DLine dline = (DLine)treeItem.getData();
                    return !TableHelper.getCell((DLine)dline, (DColumn)((DColumn)TableHelper.getTable((EObject)dline).getColumns().get(index))).some();
                }
                return false;
            }
        }));
    }

    public static String toBackgroundStyleHTMl(DTable table, boolean inverse) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(table, inverse, new TableFiller(){

            @Override
            public String getContent(DCell cell) {
                return TableUIHelper.getBackgroundStyleName((Option<DTableElementStyle>)new DCellQuery(cell).getBackgroundStyleToApply());
            }

            @Override
            public String getContent(DLine line, DColumn column) {
                return TableUIHelper.getBackgroundStyleName((Option<DTableElementStyle>)TableHelper.getBackgroundStyleToApply((DLine)line, (DColumn)column));
            }
        }));
    }

    public static String toColumnWidthHTMl(Tree tree) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(tree, new TableFiller(){

            @Override
            public String getContent(TreeItem treeItem, int index) {
                String result = "_";
                if (index != treeItem.getParent().getColumnCount() - 1) {
                    int width = treeItem.getParent().getColumn(index).getWidth();
                    result = Integer.toString(width);
                }
                return result;
            }
        }));
    }

    public static String toColumnWidthHTMl(final DTable table, boolean inverse) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(table, inverse, new TableFiller(){

            @Override
            public String getContent(DCell cell) {
                DColumn lastColumn = (DColumn)table.getColumns().get(table.getColumns().size() - 1);
                if (lastColumn.equals(cell.getColumn())) {
                    return "_";
                }
                return Integer.toString(cell.getColumn().getWidth());
            }

            @Override
            public String getContent(DLine line) {
                return "Undefined";
            }
        }));
    }

    public static String toBackgroundStyleHTMl(Tree tree) {
        return TableUIHelper.toHTML(TableUIHelper.toTableDescriptor(tree, new TableFiller(){

            @Override
            public String getContent(TreeItem treeItem, int index) {
                String result = treeItem.getText(index);
                if (index != 0) {
                    Color backgroundColor = treeItem.getBackground(index);
                    RGBValues newRGB = RGBValues.create((int)backgroundColor.getRed(), (int)backgroundColor.getGreen(), (int)backgroundColor.getBlue());
                    result = TableUIHelper.getColorName(newRGB);
                }
                return result;
            }
        }));
    }

    private static String getForegroundStyleName(Option<DTableElementStyle> optionalTableElementStyle) {
        if (optionalTableElementStyle.some() && ((DTableElementStyle)optionalTableElementStyle.get()).getForegroundColor() != null) {
            return TableUIHelper.getColorName(((DTableElementStyle)optionalTableElementStyle.get()).getForegroundColor());
        }
        return "";
    }

    private static String getBackgroundStyleName(Option<DTableElementStyle> optionalTableElementStyle) {
        if (optionalTableElementStyle.some() && ((DTableElementStyle)optionalTableElementStyle.get()).getBackgroundColor() != null) {
            return TableUIHelper.getColorName(((DTableElementStyle)optionalTableElementStyle.get()).getBackgroundColor());
        }
        return "";
    }

    private static String getColorName(RGBValues color) {
        SystemColors closest = VisualBindingManager.getDefault().findClosestStandardColor(color);
        boolean exactMatch = TableUIHelper.same(color, VisualBindingManager.getDefault().getRGBValuesFor(closest));
        if (exactMatch) {
            return closest.getName();
        }
        return "unsupported color : " + color;
    }

    private static boolean same(RGBValues a, RGBValues b) {
        return a.getRed() == b.getRed() && a.getGreen() == b.getGreen() && a.getBlue() == b.getBlue();
    }
}

