/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import org.eclipse.sirius.tests.swtbot.support.api.business.UIResource;
import org.eclipse.sirius.tests.swtbot.support.api.condition.TreeItemContainsAtLeastOneChild;
import org.eclipse.sirius.tests.swtbot.support.api.condition.TreeItemExpanded;
import org.eclipse.sirius.tests.swtbot.support.api.condition.TreeItemSelected;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;

public class UIProject {
    private final String name;
    private final SWTWorkbenchBot bot = new SWTWorkbenchBot();

    public UIProject(String pName) {
        this.name = pName;
    }

    public void open() {
        SWTBot projectExplorerBot = this.bot.viewById("org.eclipse.sirius.ui.tools.views.model.explorer").bot();
        SWTBotTree projectExplorerTree = projectExplorerBot.tree();
        projectExplorerTree.setFocus();
        SWTBotTreeItem treeItem = projectExplorerTree.getTreeItem(this.getName());
        treeItem.select();
        this.bot.waitUntil((ICondition)new TreeItemSelected(treeItem));
        SWTBotUtils.clickContextMenu(treeItem, "Open Project");
        SWTBotUtils.waitAllUiEvents();
    }

    public UIProject deleteResource(UIResource resource) {
        SWTBotTreeItem treeItem = this.getProjectTreeItem();
        try {
            for (String node : resource.getNodePath()) {
                treeItem = treeItem.expandNode(new String[]{node});
            }
            treeItem.setFocus();
            treeItem.select().contextMenu("Delete").click();
            SWTBotShell shell = this.bot.shell("Delete Resources");
            shell.activate();
            this.bot.button("OK").click();
            this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
            this.bot.sleep(500L);
        }
        catch (TimeoutException timeoutException) {}
        return this;
    }

    public SWTBotTreeItem getProjectTreeItem() {
        SWTBot projectExplorerBot = this.bot.viewById("org.eclipse.sirius.ui.tools.views.model.explorer").bot();
        SWTBotTree projectExplorerTree = projectExplorerBot.tree();
        SWTBotTreeItem treeItem = projectExplorerTree.getTreeItem(this.getName());
        TreeItemExpanded treeItemExpanded = new TreeItemExpanded(treeItem, this.getName());
        treeItem.expand();
        this.bot.waitUntil((ICondition)treeItemExpanded);
        return treeItem;
    }

    public UIProject selectResource(UIResource uiResource) {
        SWTBotTreeItem treeItem = this.getUIItemFromResource(uiResource);
        treeItem.setFocus();
        treeItem.select();
        this.bot.waitUntil((ICondition)new TreeItemSelected(treeItem));
        return this;
    }

    public SWTBotTreeItem getUIItemFromResource(UIResource uiResource) {
        SWTBotTreeItem treeItem = this.getProjectTreeItem();
        for (String node : uiResource.getNodePath()) {
            treeItem = treeItem.expandNode(new String[]{node});
            this.bot.waitUntil((ICondition)new TreeItemExpanded(treeItem, node));
        }
        this.bot.waitUntil((ICondition)new TreeItemContainsAtLeastOneChild(treeItem));
        try {
            treeItem = treeItem.getNode(uiResource.getName());
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            this.bot.sleep(2000L);
            treeItem = treeItem.getNode(uiResource.getName());
        }
        treeItem.setFocus();
        treeItem.select();
        this.bot.waitUntil((ICondition)new TreeItemSelected(treeItem));
        return treeItem;
    }

    public UIProject mouseRigthClickOnResource(UIResource uiResource, String contextualMenuLabel) {
        SWTBotTreeItem treeItem = this.getUIItemFromResource(uiResource);
        SWTBotUtils.clickContextMenu(treeItem, contextualMenuLabel);
        return this;
    }

    public UIProject mouseDoubleClickOnResource(UIResource uiResource) {
        SWTBotTreeItem treeItem = this.getUIItemFromResource(uiResource);
        treeItem.doubleClick();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void convertToModelingProject() {
        this.getProjectTreeItem().select();
        SWTBotUtils.clickContextMenu(this.getProjectTreeItem(), "Convert to Modeling Project");
    }

    public void save() {
        SWTBot projectExplorerBot = this.bot.viewById("org.eclipse.sirius.ui.tools.views.model.explorer").bot();
        SWTBotTree projectExplorerTree = projectExplorerBot.tree();
        SWTBotTreeItem treeItem = projectExplorerTree.getTreeItem("*" + this.getName());
        SWTBotUtils.clickContextMenu(treeItem, "Save");
    }

    public void select() {
        this.getProjectTreeItem().select();
    }
}

