/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.properties.section.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.ui.tools.api.properties.DTablePropertySheetpage;
import org.eclipse.sirius.ui.tools.api.properties.UndoableModelPropertySheetEntry;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractDTreePropertySection
extends AbstractPropertySection
implements IPropertySourceProvider {
    protected DTablePropertySheetpage parentPropertySheetPage;
    protected PropertySheetPage contentPage;
    protected EObject eObject;
    protected List<Object> eObjectList;
    protected AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    protected ResourceSetListener eventListener = new ResourceSetListenerImpl(this.getFilter()){

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            AbstractDTreePropertySection.this.update(event);
        }
    };
    private TransactionalEditingDomain editingDomain;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        if (aTabbedPropertySheetPage instanceof DTablePropertySheetpage) {
            this.parentPropertySheetPage = (DTablePropertySheetpage)aTabbedPropertySheetPage;
        }
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.contentPage = new PropertySheetPage();
        UndoableModelPropertySheetEntry root = new UndoableModelPropertySheetEntry(OperationHistoryFactory.getOperationHistory());
        root.setPropertySourceProvider(this.getPropertySourceProvider());
        this.contentPage.setRootEntry((IPropertySheetEntry)root);
        this.contentPage.createControl(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.height = 100;
        data.width = 100;
        this.contentPage.getControl().setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EditingDomain theEditingDomain;
        IEditingDomainProvider provider;
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            if (selection instanceof EObject) {
                this.eObject = (EObject)selection;
            }
        } else if (((IStructuredSelection)selection).getFirstElement() instanceof EObject) {
            this.eObject = (EObject)((IStructuredSelection)selection).getFirstElement();
            this.eObjectList = ((IStructuredSelection)selection).toList();
        }
        if ((provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class)) != null && (theEditingDomain = provider.getEditingDomain()) instanceof TransactionalEditingDomain) {
            this.setEditingDomain((TransactionalEditingDomain)theEditingDomain);
        }
        this.contentPage.selectionChanged(part, selection);
    }

    protected AdapterFactoryLabelProvider getAdapterFactoryLabelProvider(EObject eObj) {
        if (this.adapterFactoryLabelProvider == null) {
            if (this.getPart() instanceof AbstractDTreeEditor) {
                this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(((AbstractDTreeEditor)this.getPart()).getAdapterFactory());
            } else {
                return new AdapterFactoryLabelProvider(this.rescueAdapterFactory());
            }
        }
        return this.adapterFactoryLabelProvider;
    }

    protected AdapterFactory rescueAdapterFactory() {
        ArrayList<ComposedAdapterFactory> factories = new ArrayList<ComposedAdapterFactory>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        return new ComposedAdapterFactory(factories);
    }

    protected AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        return this.getAdapterFactoryLabelProvider(null);
    }

    protected IPropertySourceProvider getPropertySourceProvider() {
        return this;
    }

    public void dispose() {
        super.dispose();
        if (this.contentPage != null) {
            this.contentPage.dispose();
            this.contentPage = null;
        }
        if (this.eObjectList != null) {
            try {
                this.eObjectList.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        this.eObject = null;
    }

    public void refresh() {
        DslCommonPlugin.PROFILER.startWork("Refresh a section of the properties view");
        this.contentPage.refresh();
        DslCommonPlugin.PROFILER.stopWork("Refresh a section of the properties view");
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            theEditingDomain.removeResourceSetListener(this.getEventListener());
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            theEditingDomain.addResourceSetListener(this.getEventListener());
        }
    }

    protected ResourceSetListener getEventListener() {
        return this.eventListener;
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.NOT_TOUCH.and(NotificationFilter.createEventTypeFilter((int)1)).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    protected void update(ResourceSetChangeEvent event) {
        if (this.parentPropertySheetPage.isUpdateEnabled()) {
            Iterator it = event.getNotifications().iterator();
            boolean shouldUpdate = false;
            while (it.hasNext() && !shouldUpdate) {
                shouldUpdate = ((Notification)it.next()).getNotifier() instanceof EObject;
            }
            if (shouldUpdate && this.contentPage != null && this.contentPage.getControl() != null) {
                final Control control = this.contentPage.getControl();
                control.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed() && control.isVisible()) {
                            AbstractDTreePropertySection.this.refresh();
                        }
                    }
                });
            }
        }
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected void setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected AdapterFactory getAdapterFactory(Object object) {
        AdapterFactory adapterFactory = null;
        if (object != null) {
            adapterFactory = this.getPart() instanceof DTreeEditor ? ((DTreeEditor)this.getPart()).getAdapterFactory() : TreeUIPlugin.getPlugin().getItemProvidersAdapterFactory();
        }
        return adapterFactory;
    }
}

