/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.modelingproject.manager;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class AttachSemanticResourcesJob
extends Job {
    private static final String ACTION_NAME = "Attach semantic resources";
    private Map<Session, Set<URI>> semanticResourcesURIsToAttachPerSession;

    public AttachSemanticResourcesJob(Map<Session, Set<URI>> semanticResourcesURIsToAddPerSession) {
        super(ACTION_NAME);
        this.semanticResourcesURIsToAttachPerSession = semanticResourcesURIsToAddPerSession;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask(ACTION_NAME, 6 * this.semanticResourcesURIsToAttachPerSession.size());
                for (Session session : this.semanticResourcesURIsToAttachPerSession.keySet()) {
                    if (session == null || !session.isOpen()) continue;
                    Set<URI> semanticResourcesURIsToAdd = this.semanticResourcesURIsToAttachPerSession.get(session);
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (URI semanticResourcesURI : semanticResourcesURIsToAdd) {
                        AddSemanticResourceCommand addSemanticResourceCmd = new AddSemanticResourceCommand(session, semanticResourcesURI, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                        compoundCommand.append((Command)addSemanticResourceCmd);
                    }
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)compoundCommand);
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                SiriusPlugin.getDefault().error(e.getMessage(), e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return "org.eclipse.sirius.representationsFile".equals(family);
    }
}

