/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;

public class RepresentationsChangeAdapter
extends AdapterImpl {
    private Session session;

    public RepresentationsChangeAdapter(Session session) {
        this.session = session;
    }

    public void notifyChanged(Notification n) {
        Object notifier = n.getNotifier();
        if (notifier instanceof DAnalysis && n.getFeatureID(DAnalysis.class) == 4) {
            switch (n.getEventType()) {
                case 3: {
                    DView newView = (DView)n.getNewValue();
                    this.registerView(newView);
                    break;
                }
                case 4: 
                case 6: {
                    this.safeUnregisterViews(n.getOldValue());
                    break;
                }
            }
        } else if (notifier instanceof DView && n.getFeatureID(DView.class) == 0) {
            switch (n.getEventType()) {
                case 3: {
                    SessionManager.INSTANCE.notifyRepresentationCreated(this.session);
                    break;
                }
                case 4: 
                case 6: {
                    SessionManager.INSTANCE.notifyRepresentationDeleted(this.session);
                    break;
                }
            }
        }
    }

    private void safeUnregisterViews(Object oldValue) {
        if (oldValue instanceof DView) {
            DView oldView = (DView)oldValue;
            this.unregisterView(oldView);
        } else if (oldValue instanceof Collection) {
            for (DView oldView : Iterables.filter((Iterable)((Collection)oldValue), DView.class)) {
                this.unregisterView(oldView);
            }
        }
    }

    public void registerAnalysis(DAnalysis analysis) {
        analysis.eAdapters().add((Object)this);
        for (DView view : analysis.getOwnedViews()) {
            this.registerView(view);
        }
    }

    public void unregisterAnalysis(DAnalysis analysis) {
        if (analysis.eAdapters().contains((Object)this)) {
            analysis.eAdapters().remove((Object)this);
        }
        for (DView view : analysis.getOwnedViews()) {
            this.unregisterView(view);
        }
    }

    private void registerView(DView view) {
        view.eAdapters().add((Object)this);
    }

    private void unregisterView(DView view) {
        if (view.eAdapters().contains((Object)this)) {
            view.eAdapters().remove((Object)this);
        }
    }
}

