/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;

public class SaveSessionJob
extends Job {
    public static final String FAMILY = "org.eclipse.sirius.saveSessionJob";
    private static final String ACTION_NAME = "Session saving";
    private Session session;

    public SaveSessionJob(Session session) {
        super(ACTION_NAME);
        this.session = session;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(ACTION_NAME, -1);
            if (this.session != null && this.session.isOpen() && SessionStatus.DIRTY == this.session.getStatus()) {
                if (this.session instanceof DAnalysisSessionImpl) {
                    boolean exclusiveSetting = ((DAnalysisSessionImpl)this.session).isSaveInExclusiveTransaction();
                    ((DAnalysisSessionImpl)this.session).setSaveInExclusiveTransaction(false);
                    try {
                        this.session.save(monitor);
                    }
                    finally {
                        ((DAnalysisSessionImpl)this.session).setSaveInExclusiveTransaction(exclusiveSetting);
                    }
                } else {
                    this.session.save(monitor);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
            this.session = null;
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return FAMILY.equals(family);
    }
}

