/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.interpreter.context.SiriusInterpreterContextFactory;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public class ValidInterpretedExpressionConstraint
extends AbstractConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        LinkedHashSet statuses = Sets.newLinkedHashSet();
        for (EAttribute feature : target.eClass().getEAllAttributes()) {
            IStatus status;
            if (!DescriptionPackage.eINSTANCE.getInterpretedExpression().equals(feature.getEAttributeType()) || (status = this.checkExpression(ctx, target, (EStructuralFeature)feature)) == null) continue;
            statuses.add(status);
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        IStatus returnStatus = statuses.size() == 1 ? (IStatus)statuses.iterator().next() : ConstraintStatus.createMultiStatus((IValidationContext)ctx, (Collection)statuses);
        return returnStatus;
    }

    private IStatus checkExpression(IValidationContext ctx, EObject target, EStructuralFeature feature) {
        String expression = (String)target.eGet(feature);
        Collection errors = Sets.newLinkedHashSet();
        if (!StringUtil.isEmpty((String)expression)) {
            IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext(target, feature);
            errors = MultiLanguagesValidator.getInstance().validateExpression(context, expression).getStatuses();
        }
        if (errors.isEmpty()) {
            return null;
        }
        LinkedHashSet statuses = Sets.newLinkedHashSet();
        Set<EObject> locus = Collections.singleton(target);
        for (IInterpreterStatus interpreterStatus : errors) {
            statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, locus, (String)interpreterStatus.getMessage(), (Object[])new Object[0]));
        }
        IStatus returnStatus = statuses.size() == 1 ? (IStatus)statuses.iterator().next() : ConstraintStatus.createMultiStatus((IValidationContext)ctx, (Collection)statuses);
        return returnStatus;
    }
}

