/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description.util;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMResourceXMILoad;
import org.eclipse.sirius.business.internal.migration.description.VSMXMIHelper;
import org.eclipse.sirius.ext.base.Option;

public class DescriptionResourceImpl
extends XMIResourceImpl {
    public static final String OPTION_USE_URI_FRAGMENT_AS_ID = "SIRIUS_USE_URI_FRAGMENT_AS_ID";
    private boolean useURIFragmentAsId;

    protected DescriptionResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLHelper createXMLHelper() {
        return new VSMXMIHelper((XMLResource)this);
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        if (options != null && options.containsKey("RESOURCE_MIGRATION_LOADEDVERSION")) {
            String loadedVersion = null;
            Object mapVersion = options.get("RESOURCE_MIGRATION_LOADEDVERSION");
            if (mapVersion instanceof String) {
                loadedVersion = (String)mapVersion;
            }
            return new VSMResourceXMILoad(loadedVersion, this.createXMLHelper());
        }
        return super.createXMLLoad(options);
    }

    public void setModified(boolean isModified) {
        super.setModified(isModified);
        if (isModified) {
            this.getIDToEObjectMap().clear();
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        this.useURIFragmentAsId = Boolean.TRUE.equals(options.get(OPTION_USE_URI_FRAGMENT_AS_ID)) && this.getURI().isPlatformPlugin();
        super.load(options);
    }

    public EObject getEObject(String uriFragment) {
        Option<String> optionalRewrittenFragment = VSMMigrationService.getInstance().getNewFragment(uriFragment);
        if (optionalRewrittenFragment.some()) {
            return this.getEObject((String)optionalRewrittenFragment.get());
        }
        if (this.useURIFragmentAsId) {
            return this.getEObjectUsingURIFragmentAsId(uriFragment);
        }
        return super.getEObject(uriFragment);
    }

    private EObject getEObjectUsingURIFragmentAsId(String uriFragment) {
        EObject eObject = null;
        if (this.isLoading) {
            eObject = this.getEObjectAndUpdateIDMap(uriFragment);
        } else {
            eObject = this.getEObjectByID(uriFragment);
            if (eObject == null) {
                eObject = this.getEObjectAndUpdateIDMap(uriFragment);
            }
        }
        return eObject;
    }

    private EObject getEObjectAndUpdateIDMap(String uriFragment) {
        EObject eObject = super.getEObject(uriFragment);
        if (eObject != null) {
            this.setID(eObject, uriFragment);
        }
        return eObject;
    }
}

