/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.scxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HistoryTypeDatatype implements Enumerator
{
    SHALLOW(0, "shallow", "shallow"),
    DEEP(1, "deep", "deep");

    public static final int SHALLOW_VALUE = 0;
    public static final int DEEP_VALUE = 1;
    private static final HistoryTypeDatatype[] VALUES_ARRAY;
    public static final List<HistoryTypeDatatype> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HistoryTypeDatatype[]{SHALLOW, DEEP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HistoryTypeDatatype get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HistoryTypeDatatype result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HistoryTypeDatatype getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HistoryTypeDatatype result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HistoryTypeDatatype get(int value) {
        switch (value) {
            case 0: {
                return SHALLOW;
            }
            case 1: {
                return DEEP;
            }
        }
        return null;
    }

    private HistoryTypeDatatype(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

