/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.unit.common.TreeCommonTest;
import org.eclipse.sirius.tests.unit.common.TreeEcoreModeler;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.description.DescriptionFactory;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.ui.business.api.helper.TreeUIHelper;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

public class TreeItemCreationToolsTest
extends TreeCommonTest
implements TreeEcoreModeler {
    private static final String REQUEST = "<%getRootContainer().eAllContents(\"EClass\")[name==\"NewEClassCreationTool\"].nSize()%>";
    private TreeItemMapping treeItemMapping;
    private AbstractDTreeEditor treeEditor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initViewpoint("TreeSirius");
        TestsUtil.synchronizationWithUIThread();
    }

    public void _testCreateCreationTools() throws Exception {
        final TreeItemCreationTool treeItemCreationTool = DescriptionFactory.eINSTANCE.createTreeItemCreationTool();
        TreeDescription treeDescription = this.find("Tree");
        Assert.assertNotNull((String)"The unit test data seems incorrect", (Object)treeDescription);
        Assert.assertEquals((String)"The unit test data seems incorrect", (long)3L, (long)treeDescription.getSubItemMappings().size());
        this.treeItemMapping = (TreeItemMapping)treeDescription.getSubItemMappings().get(0);
        Assert.assertTrue((boolean)"Package".equals(this.treeItemMapping.getName()));
        Assert.assertTrue((String)"The unit test data seems incorrect", (this.treeItemMapping.getCreate().size() == 0 ? 1 : 0) != 0);
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                TreeItemCreationToolsTest.this.treeItemMapping.getCreate().add((Object)treeItemCreationTool);
            }
        });
        Assert.assertNotNull((String)"The setting of the creation tool failed.", (Object)this.treeItemMapping.getCreate());
        Assert.assertTrue((String)"The setting of the creation tool failed.", (this.treeItemMapping.getCreate().size() > 0 ? 1 : 0) != 0);
    }

    public void _testCreateCreationToolsOnRepresentation() throws Exception {
        final TreeItemCreationTool treeItemCreationTool = DescriptionFactory.eINSTANCE.createTreeItemCreationTool();
        final TreeDescription treeDescription = this.find("Tree");
        Assert.assertNotNull((String)"The unit test data seems incorrect", (Object)treeDescription);
        Assert.assertTrue((String)"The unit test data seems incorrect", (treeDescription.getCreateTreeItem().size() == 1 ? 1 : 0) != 0);
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                treeDescription.getCreateTreeItem().add((Object)treeItemCreationTool);
            }
        });
        Assert.assertNotNull((String)"The setting of the creation tool failed.", (Object)treeDescription.getCreateTreeItem());
        Assert.assertTrue((String)"The setting of the creation tool failed.", (treeDescription.getCreateTreeItem().size() == 2 ? 1 : 0) != 0);
    }

    public void _testCreateUndo() {
        TreeDescription treeDescription = this.find("Tree");
        Assert.assertNotNull((String)"The unit test data seems incorrect", (Object)treeDescription);
        Assert.assertEquals((String)"The unit test data seems incorrect", (long)3L, (long)treeDescription.getSubItemMappings().size());
        this.treeItemMapping = (TreeItemMapping)treeDescription.getSubItemMappings().get(1);
        DTree newTree = (DTree)this.getRepresentations("Tree").toArray()[0];
        TreeDescription desc = newTree.getDescription();
        Assert.assertNotNull((String)"No tree descrition.", (Object)desc);
        Assert.assertTrue((newTree.getOwnedTreeItems().size() >= 2 ? 1 : 0) != 0);
        DTreeElement treeElement = (DTreeElement)newTree.getOwnedTreeItems().get(1);
        IEditorPart openedEditor = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)newTree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.treeEditor = (AbstractDTreeEditor)openedEditor;
        Tree tree = this.treeEditor.getTableViewer().getTreeViewer().getTree();
        this.testTreeContent(tree, newTree);
        Assert.assertNotNull((String)"Unit test data is not correct", (Object)desc);
        try {
            this.testCreationOnMapping(newTree, treeElement, tree);
            this.testUndo(newTree, tree);
            this.testRedo(newTree, tree);
        }
        catch (EvaluationException e) {
            Assert.fail((String)"Exception while trying to get the value.");
            e.printStackTrace();
        }
    }

    private void testCreationOnMapping(DTree newTree, DTreeElement treeElement, Tree tree) throws EvaluationException {
        int instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
        Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)0L, (long)instanceCount);
        this.applyCreationTool((DTreeItemContainer)newTree, treeElement.getTarget(), (TreeItemCreationTool)this.treeItemMapping.getCreate().get(0));
        instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
        Assert.assertEquals((String)"Wrong count of elementhaving the wanted value.", (long)1L, (long)instanceCount);
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertEquals((String)"The creation is not effetive in editor", (Object)TreeItemCreationToolsTest.getModelHtmlAfterCreate(), (Object)currentHtml);
    }

    public void testCreateInRepresentation() {
        TreeDescription treeDescription = this.find("Tree");
        Assert.assertNotNull((String)"The unit test data seems incorrect", (Object)treeDescription);
        DTree newTree = (DTree)this.getRepresentations("Tree").toArray()[0];
        TreeDescription desc = newTree.getDescription();
        Assert.assertNotNull((String)"No tree descrition.", (Object)desc);
        IEditorPart openedEditor = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)newTree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        Assert.assertNotNull((String)"The tree editor is not opened", (Object)openedEditor);
        Assert.assertTrue((String)"The tree editor is not opened", (boolean)(openedEditor instanceof DTreeEditor));
        this.treeEditor = (AbstractDTreeEditor)openedEditor;
        Tree tree = this.treeEditor.getTableViewer().getTreeViewer().getTree();
        Assert.assertNotNull((String)"The tree is null", (Object)tree);
        this.testTreeContent(tree, newTree);
        try {
            this.testCreationToolOnRepresentation(treeDescription, newTree, tree);
            this.testUndo(newTree, tree);
            this.testRedo(newTree, tree);
        }
        catch (EvaluationException e) {
            Assert.fail((String)"Exception while trying to get the value.");
            e.printStackTrace();
        }
    }

    private void testTreeContent(Tree tree, DTree newTree) {
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertEquals((String)"The editor has not the good number element", (Object)TreeItemCreationToolsTest.getModelHtml(), (Object)currentHtml);
        Assert.assertEquals((String)"We have 8 elements in ecore model, so we should have 8 elements in tree.", (long)8L, (long)newTree.getOwnedTreeItems().size());
    }

    private void testRedo(DTree newTree, Tree tree) throws EvaluationException {
        this.applyRedo();
        this.applyRedo();
        TestsUtil.synchronizationWithUIThread();
        int instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
        Assert.assertEquals((String)"Wrong count of elementhaving the wanted value.", (long)1L, (long)instanceCount);
        Assert.assertEquals((String)"We have 10 elements in ecore model, so we should have 10 elements in tree.", (long)9L, (long)newTree.getOwnedTreeItems().size());
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertEquals((String)"The creation is not effetive in editor", (Object)TreeItemCreationToolsTest.getModelHtmlAfterCreate(), (Object)currentHtml);
    }

    private void testUndo(DTree newTree, Tree tree) throws EvaluationException {
        this.applyUndo();
        this.applyUndo();
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"We have 9 elements in ecore model, so we should have 9 elements in tree.", (long)8L, (long)newTree.getOwnedTreeItems().size());
        int instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
        Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)0L, (long)instanceCount);
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertTrue((String)"The undo is not effetive visually", (TreeItemCreationToolsTest.getModelHtml().length() == currentHtml.length() ? 1 : 0) != 0);
    }

    private void testCreationToolOnRepresentation(TreeDescription treeDescription, DTree newTree, Tree tree) throws EvaluationException {
        int instanceCount = -1;
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
        Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)0L, (long)instanceCount);
        Assert.assertFalse((String)"No creation tool is defined on the tree representation.", (boolean)treeDescription.getCreateTreeItem().isEmpty());
        this.applyCreationTool((DTreeItemContainer)newTree, newTree.getTarget(), (TreeItemCreationTool)treeDescription.getCreateTreeItem().get(0));
        TestsUtil.synchronizationWithUIThread();
        instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
        Assert.assertEquals((String)"Wrong count of elementhaving the wanted value.", (long)1L, (long)instanceCount);
        Assert.assertEquals((String)"We have 10 elements in ecore model, so we should have 9 elements in tree.", (long)9L, (long)newTree.getOwnedTreeItems().size());
        this.refresh((DRepresentation)newTree, true);
        currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertEquals((String)"The creation is not effetive in editor", (Object)TreeItemCreationToolsTest.getModelHtmlAfterCreate(), (Object)currentHtml);
    }

    private static String getModelHtml() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("sous package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P11"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P12"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass1 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("myAttribute"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("myAttribute2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum2"));
        return TreeUIHelper.toHTML(expected);
    }

    private static String getModelHtmlAfterCreate() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("sous package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P11"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P11 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P12"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P12 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass1 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("myAttribute"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("myAttribute2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClassCreationTool"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClassCreationTool Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum2"));
        return TreeUIHelper.toHTML(expected);
    }

    @Override
    protected void tearDown() throws Exception {
        DialectUIManager.INSTANCE.closeEditor((IEditorPart)this.treeEditor, false);
        TestsUtil.synchronizationWithUIThread();
        this.treeItemMapping = null;
        this.treeEditor = null;
        super.tearDown();
    }
}

