/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorsAndFontsPropertySection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ResetStylePropertiesToDefaultValuesCommand;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class ResetStylePropertiesToDefaultValuesSelectionAdapter
extends SelectionAdapter {
    private ColorsAndFontsPropertySection colorAndFontPropertySection;

    public ResetStylePropertiesToDefaultValuesSelectionAdapter(ColorsAndFontsPropertySection colorAndFontPropertySection) {
        this.colorAndFontPropertySection = colorAndFontPropertySection;
    }

    public void widgetSelected(SelectionEvent e) {
        List input = this.colorAndFontPropertySection.getInput();
        if (!input.isEmpty()) {
            DDiagram dDiagram = (DDiagram)this.colorAndFontPropertySection.getSingleInput().getNotationView().getDiagram().getElement();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dDiagram);
            LinkedHashMap<View, DDiagramElement> customizedViews = new LinkedHashMap<View, DDiagramElement>();
            HashMap<IGraphicalEditPart, Style> oldStyles = new HashMap<IGraphicalEditPart, Style>();
            for (Object obj : input) {
                if (!(obj instanceof IGraphicalEditPart)) continue;
                IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)obj;
                View notationView = graphicalEditPart.getNotationView();
                DDiagramElement dDiagramElement = null;
                EObject semanticElement = graphicalEditPart.resolveSemanticElement();
                if (semanticElement instanceof DDiagramElement) {
                    dDiagramElement = (DDiagramElement)semanticElement;
                    if (!new DDiagramElementQuery(dDiagramElement).isCustomized() && !new ViewQuery(notationView).isCustomized()) continue;
                    customizedViews.put(notationView, dDiagramElement);
                    oldStyles.put(graphicalEditPart, dDiagramElement.getStyle());
                    continue;
                }
                if (semanticElement instanceof DSemanticDiagram) {
                    for (Object graphicalEditParChild : graphicalEditPart.getChildren()) {
                        if (!(graphicalEditParChild instanceof IGraphicalEditPart)) continue;
                        IGraphicalEditPart subGraphicalEditPart = (IGraphicalEditPart)graphicalEditParChild;
                        View subNotationView = subGraphicalEditPart.getNotationView();
                        EObject subSemanticElement = subGraphicalEditPart.resolveSemanticElement();
                        if (subSemanticElement instanceof DDiagramElement && (new DDiagramElementQuery((DDiagramElement)subSemanticElement).isCustomized() || new ViewQuery(subNotationView).isCustomized())) {
                            customizedViews.put(subNotationView, (DDiagramElement)subSemanticElement);
                            oldStyles.put(subGraphicalEditPart, ((DDiagramElement)subSemanticElement).getStyle());
                            continue;
                        }
                        if (dDiagramElement != null || !new ViewQuery(subNotationView).isCustomized()) continue;
                        customizedViews.put(subNotationView, dDiagramElement);
                    }
                    continue;
                }
                if (dDiagramElement != null || !new ViewQuery(notationView).isCustomized()) continue;
                customizedViews.put(notationView, dDiagramElement);
            }
            if (!customizedViews.isEmpty()) {
                ResetStylePropertiesToDefaultValuesCommand resetStylePropertiesToDefaultValuesCommand = new ResetStylePropertiesToDefaultValuesCommand(domain, dDiagram, customizedViews);
                domain.getCommandStack().execute((Command)resetStylePropertiesToDefaultValuesCommand);
                Set entrySet = oldStyles.entrySet();
                for (Map.Entry entry : entrySet) {
                    if (!(entry.getKey() instanceof AbstractDiagramContainerEditPart)) continue;
                    AbstractDiagramContainerEditPart graphicalEditPart = (AbstractDiagramContainerEditPart)entry.getKey();
                    graphicalEditPart.reInitFigure();
                }
            }
        }
    }

    public static boolean isCustomizedView(View view) {
        DDiagramElement dDiagramElement;
        DDiagramElementQuery dDiagramElementQuery;
        boolean isCustomized = false;
        EObject element = view.getElement();
        if (element instanceof DDiagramElement && (dDiagramElementQuery = new DDiagramElementQuery(dDiagramElement = (DDiagramElement)element)).isCustomized()) {
            isCustomized = true;
        }
        ViewQuery viewQuery = new ViewQuery(view);
        if (!isCustomized && viewQuery.isCustomized()) {
            isCustomized = true;
        }
        return isCustomized;
    }
}

