/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.CreateContainerTask;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationVariable;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class ContainerCreationCommandBuilder
extends AbstractDiagramCommandBuilder {
    protected ContainerCreationDescription tool;
    protected DDiagramElementContainer nodeContainer;
    protected DDiagram diagram;
    private final boolean createInDiagram;

    public ContainerCreationCommandBuilder(ContainerCreationDescription tool, DDiagramElementContainer nodeContainer) {
        this.tool = tool;
        this.nodeContainer = nodeContainer;
        this.diagram = nodeContainer.getParentDiagram();
        this.createInDiagram = false;
    }

    public ContainerCreationCommandBuilder(ContainerCreationDescription tool, DDiagram diagram) {
        this.tool = tool;
        this.diagram = diagram;
        this.createInDiagram = true;
    }

    public Command buildCommand() {
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        if (this.createInDiagram && this.diagram != null) {
            command = this.buildInDiagramCommand();
        } else if (this.nodeContainer != null) {
            command = this.buildInDNodeContainerCommand();
        }
        return command;
    }

    private Command buildInDiagramCommand() {
        EObject model = null;
        if (this.permissionAuthority.canEditInstance((EObject)this.diagram)) {
            if (this.diagram instanceof DSemanticDiagram) {
                model = ((DSemanticDiagram)this.diagram).getTarget();
            }
            if (model != null && this.checkPrecondition(this.diagram, (AbstractToolDescription)this.tool)) {
                DCommand result = this.buildCreateNodeCommandFromTool(model, this.diagram);
                result.getTasks().add(new CreateContainerTask(this.tool, result, this.modelAccessor, this.diagram));
                this.addRefreshTask(this.diagram, result, (AbstractToolDescription)this.tool);
                return result;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command buildInDNodeContainerCommand() {
        EObject model;
        if (this.canCreateContainerInTarget() && (model = this.nodeContainer.getTarget()) != null && this.checkPrecondition(this.nodeContainer, (AbstractToolDescription)this.tool)) {
            DCommand result = this.buildCreateNodeCommandFromTool(model, this.nodeContainer);
            result.getTasks().add(new CreateContainerTask(this.tool, result, this.modelAccessor, this.nodeContainer));
            this.addRefreshTask(this.nodeContainer, result, (AbstractToolDescription)this.tool);
            return result;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected DCommand buildCreateNodeCommandFromTool(EObject semanticContainer, EObject container) {
        DCommand result = this.createEnclosingCommand();
        if (this.canCreateContainerInTarget()) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)semanticContainer);
            HashMap<NodeCreationVariable, EObject> variables = new HashMap<NodeCreationVariable, EObject>();
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            variables.put(this.tool.getVariable(), semanticContainer);
            variables.put((NodeCreationVariable)this.tool.getViewVariable(), container);
            this.addDiagramVariable(result, container, interpreter);
            Option<DDiagram> parentDiagram = new EObjectQuery(container).getParentDiagram();
            result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), semanticContainer, this.tool.getInitialOperation().getFirstModelOperations()));
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    private boolean canCreateContainerInTarget() {
        boolean containerCanBeCreatedInTarget = false;
        if (this.nodeContainer != null) {
            containerCanBeCreatedInTarget = this.permissionAuthority.canEditInstance((EObject)this.nodeContainer);
            if (containerCanBeCreatedInTarget) {
                EObject target = this.nodeContainer.getTarget();
                containerCanBeCreatedInTarget = target != null && !target.eIsProxy();
            }
        } else if (this.diagram != null && (containerCanBeCreatedInTarget = this.permissionAuthority.canEditInstance((EObject)this.diagram)) && this.diagram instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)this.diagram).getTarget();
            containerCanBeCreatedInTarget = target != null && !target.eIsProxy();
        }
        return containerCanBeCreatedInTarget;
    }

    protected String getEnclosingCommandLabel() {
        return new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel();
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        return Options.newSome((Object)this.diagram);
    }
}

