/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.properties.section.description.containermapping;

import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.editor.properties.sections.description.containermapping.ContainerMappingChildrenPresentationPropertySection;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ContainerMappingChildrenPresentationPropertySectionSpec
extends ContainerMappingChildrenPresentationPropertySection {
    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        String hStackButtonText = this.getText(ContainerLayout.HORIZONTAL_STACK);
        String vStackButtonText = this.getText(ContainerLayout.VERTICAL_STACK);
        Button[] buttonArray = this.button;
        int n = this.button.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            if (hStackButtonText.equals(b.getText()) || vStackButtonText.equals(b.getText())) {
                b.setToolTipText("Experimental");
                Font f = b.getFont();
                if (f != null && f.getFontData().length > 0) {
                    FontData fontData = f.getFontData()[0];
                    Font italic = SiriusEditor.getFontRegistry().getItalic(fontData.getName());
                    if (italic != null) {
                        b.setFont(italic);
                    }
                }
            }
            ++n2;
        }
    }

    protected void makeWrittable() {
        super.makeWrittable();
        if (this.button != null && this.eObject instanceof ContainerMapping) {
            boolean stackButtonEnabled = this.shouldEnableCompartiments((ContainerMapping)this.eObject);
            String hStackButtonText = this.getText(ContainerLayout.HORIZONTAL_STACK);
            String vStackButtonText = this.getText(ContainerLayout.VERTICAL_STACK);
            Button[] buttonArray = this.button;
            int n = this.button.length;
            int n2 = 0;
            while (n2 < n) {
                Button b = buttonArray[n2];
                if (hStackButtonText.equals(b.getText()) || vStackButtonText.equals(b.getText())) {
                    b.setEnabled(stackButtonEnabled);
                }
                ++n2;
            }
        }
    }

    private boolean shouldEnableCompartiments(ContainerMapping containerMapping) {
        boolean enableCompartiments;
        ContainerMappingQuery query = new ContainerMappingQuery(containerMapping);
        boolean bl = enableCompartiments = !query.isRegion();
        if (enableCompartiments) {
            for (ContainerMapping subContainer : containerMapping.getAllContainerMappings()) {
                ContainerMappingQuery subQuery = new ContainerMappingQuery(subContainer);
                boolean bl2 = enableCompartiments = enableCompartiments && !subQuery.isRegionContainer();
            }
        }
        if (enableCompartiments) {
            enableCompartiments = enableCompartiments && containerMapping.getAllNodeMappings().isEmpty();
        }
        return enableCompartiments;
    }
}

