/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.print;

import org.eclipse.sirius.table.ui.tools.internal.editor.print.PrintHelper;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.ImagePrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.LinePrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintJob;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.ScalePrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.LineBorder;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.DefaultGridLook;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.GridColumn;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.grid.GridPrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.PageDecoration;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.PageNumberPageDecoration;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.PagePrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.page.SimplePageDecoration;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.text.TextPrint;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PaperClipsPrintHelper
implements PrintHelper {
    private final PrinterData printerData;
    private final Control control;

    public PaperClipsPrintHelper(PrinterData printerData, Control control) {
        this.printerData = printerData;
        this.control = control;
    }

    @Override
    public void launchPrintJob(String name) {
        Print print = this.createPrint(name);
        PaperClips.print(new PrintJob(name, print).setMargins(72), this.printerData);
    }

    private Print createPrint(String name) {
        Print body = this.getBody();
        PageDecoration header = this.getHeader(name);
        PageDecoration footer = this.getFooter();
        return new PagePrint(header, body, footer);
    }

    private Print getBody() {
        TreeColumn[] columns;
        Tree tree = this.findTree();
        DefaultGridLook look = new DefaultGridLook();
        look.setCellBorder(new LineBorder());
        RGB background = tree.getDisplay().getSystemColor(22).getRGB();
        look.setHeaderBackground(background);
        look.setFooterBackground(background);
        GridPrint grid = new GridPrint(look);
        TreeColumn[] treeColumnArray = columns = tree.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            grid.addColumn(new GridColumn(col.getAlignment(), -1, 0));
            Print cell = this.createCell("", col.getImage(), col.getText(), 0x1000000);
            grid.addHeader(cell);
            ++n2;
        }
        this.createTreeItemRows("", grid, tree.getItems(), columns);
        return new ScalePrint(grid);
    }

    private Tree findTree() {
        Tree tree = null;
        if (this.control instanceof Tree) {
            tree = (Tree)this.control;
        } else if (this.control instanceof Composite && ((Composite)this.control).getChildren()[0] instanceof Tree) {
            tree = (Tree)((Composite)this.control).getChildren()[0];
        }
        return tree;
    }

    private void createTreeItemRows(String offset, GridPrint grid, TreeItem[] items, TreeColumn[] columns) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.createTreeItemrow(offset, grid, item, columns);
            ++n2;
        }
    }

    private void createTreeItemrow(String offset, GridPrint grid, TreeItem item, TreeColumn[] columns) {
        int i = 0;
        while (i < columns.length) {
            grid.add(this.createCell(offset, item.getImage(i), item.getText(i), columns[i].getAlignment()));
            ++i;
        }
        String newOffset = String.valueOf(offset) + "   ";
        this.createTreeItemRows(newOffset, grid, item.getItems(), columns);
    }

    private Print createCell(String offset, Image image, String text, int align) {
        if (image == null) {
            return new TextPrint(text, align);
        }
        GridPrint grid = new GridPrint("p, p, d");
        grid.add(new TextPrint(offset));
        grid.add(new ImagePrint(image.getImageData(), image.getDevice().getDPI()));
        grid.add(new TextPrint(text, align));
        return grid;
    }

    private PageDecoration getHeader(String name) {
        GridPrint headerGrid = new GridPrint("d:g");
        headerGrid.add(new TextPrint(name));
        headerGrid.add(new LinePrint(256), -1);
        return new SimplePageDecoration(headerGrid);
    }

    private PageDecoration getFooter() {
        return new PageNumberPageDecoration();
    }

    @Override
    public void dispose() {
    }
}

