/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.transaction.util.ValidateEditSupport;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.ext.emf.tx.DelegatingValidateEditSupport;

public class ResourceModifiedFieldUpdater
extends DelegatingValidateEditSupport {
    private InternalTransactionalEditingDomain domain;
    private Set<Resource> changedResources = new LinkedHashSet<Resource>();

    public ResourceModifiedFieldUpdater(InternalTransactionalEditingDomain domain, ValidateEditSupport delegate) {
        super(delegate);
        this.domain = domain;
        TransactionalEditingDomain.DefaultOptions options = (TransactionalEditingDomain.DefaultOptions)TransactionUtil.getAdapter((TransactionalEditingDomain)domain, TransactionalEditingDomain.DefaultOptions.class);
        if (options != null) {
            HashMap<String, ResourceModifiedFieldUpdater> aMap = new HashMap<String, ResourceModifiedFieldUpdater>();
            aMap.put("validate_edit", this);
            options.setDefaultTransactionOptions(aMap);
        }
    }

    public void handleResourceChange(Resource resource, Notification notification) {
        super.handleResourceChange(resource, notification);
        if (!resource.isModified() && !this.isInLoad(resource) && !this.changedResources.contains(resource) && this.isResourceModelChange(notification)) {
            this.changedResources.add(resource);
        }
    }

    private boolean isResourceModelChange(Notification notification) {
        return (notification.getNotifier() instanceof EObject || notification.getFeatureID(null) == 2) && !new NotificationQuery(notification).isTransientNotification();
    }

    private boolean isInLoad(Resource resource) {
        boolean isInLoad = resource instanceof Resource.Internal && ((Resource.Internal)resource).isLoading();
        return isInLoad;
    }

    public void finalizeForCommit() {
        super.finalizeForCommit();
        if (!this.domain.getActiveTransaction().isReadOnly()) {
            for (Resource modifiedResource : this.changedResources) {
                modifiedResource.setModified(true);
            }
        }
        this.changedResources.clear();
    }

    public void finalizeForRollback() {
        super.finalizeForRollback();
        this.changedResources.clear();
    }
}

