/**
 * Copyright (c) 2015 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Obeo - initial API and implementation
 */
package org.eclipse.sirius.tests.sample.scxml.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.sirius.tests.sample.scxml.ScxmlPackage;
import org.eclipse.sirius.tests.sample.scxml.ScxmlParamType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Param Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.sirius.tests.sample.scxml.impl.ScxmlParamTypeImpl#getScxmlExtraContent <em>Scxml Extra Content</em>}</li>
 *   <li>{@link org.eclipse.sirius.tests.sample.scxml.impl.ScxmlParamTypeImpl#getAny <em>Any</em>}</li>
 *   <li>{@link org.eclipse.sirius.tests.sample.scxml.impl.ScxmlParamTypeImpl#getExpr <em>Expr</em>}</li>
 *   <li>{@link org.eclipse.sirius.tests.sample.scxml.impl.ScxmlParamTypeImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.sirius.tests.sample.scxml.impl.ScxmlParamTypeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.sirius.tests.sample.scxml.impl.ScxmlParamTypeImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ScxmlParamTypeImpl extends MinimalEObjectImpl.Container implements ScxmlParamType {
    /**
     * The cached value of the '{@link #getScxmlExtraContent() <em>Scxml Extra Content</em>}' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getScxmlExtraContent()
     * @generated
     * @ordered
     */
    protected FeatureMap scxmlExtraContent;

    /**
     * The default value of the '{@link #getExpr() <em>Expr</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExpr()
     * @generated
     * @ordered
     */
    protected static final String EXPR_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getExpr() <em>Expr</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExpr()
     * @generated
     * @ordered
     */
    protected String expr = EXPR_EDEFAULT;

    /**
     * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected static final String LOCATION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected String location = LOCATION_EDEFAULT;

    /**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected static final String NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected String name = NAME_EDEFAULT;

    /**
     * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAnyAttribute()
     * @generated
     * @ordered
     */
    protected FeatureMap anyAttribute;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScxmlParamTypeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return ScxmlPackage.Literals.SCXML_PARAM_TYPE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public FeatureMap getScxmlExtraContent() {
        if (scxmlExtraContent == null) {
            scxmlExtraContent = new BasicFeatureMap(this, ScxmlPackage.SCXML_PARAM_TYPE__SCXML_EXTRA_CONTENT);
        }
        return scxmlExtraContent;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public FeatureMap getAny() {
        return (FeatureMap)getScxmlExtraContent().<FeatureMap.Entry>list(ScxmlPackage.Literals.SCXML_PARAM_TYPE__ANY);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getExpr() {
        return expr;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setExpr(String newExpr) {
        String oldExpr = expr;
        expr = newExpr;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ScxmlPackage.SCXML_PARAM_TYPE__EXPR, oldExpr, expr));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLocation() {
        return location;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLocation(String newLocation) {
        String oldLocation = location;
        location = newLocation;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ScxmlPackage.SCXML_PARAM_TYPE__LOCATION, oldLocation, location));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ScxmlPackage.SCXML_PARAM_TYPE__NAME, oldName, name));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public FeatureMap getAnyAttribute() {
        if (anyAttribute == null) {
            anyAttribute = new BasicFeatureMap(this, ScxmlPackage.SCXML_PARAM_TYPE__ANY_ATTRIBUTE);
        }
        return anyAttribute;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case ScxmlPackage.SCXML_PARAM_TYPE__SCXML_EXTRA_CONTENT:
                return ((InternalEList<?>)getScxmlExtraContent()).basicRemove(otherEnd, msgs);
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY:
                return ((InternalEList<?>)getAny()).basicRemove(otherEnd, msgs);
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY_ATTRIBUTE:
                return ((InternalEList<?>)getAnyAttribute()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case ScxmlPackage.SCXML_PARAM_TYPE__SCXML_EXTRA_CONTENT:
                if (coreType) return getScxmlExtraContent();
                return ((FeatureMap.Internal)getScxmlExtraContent()).getWrapper();
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY:
                if (coreType) return getAny();
                return ((FeatureMap.Internal)getAny()).getWrapper();
            case ScxmlPackage.SCXML_PARAM_TYPE__EXPR:
                return getExpr();
            case ScxmlPackage.SCXML_PARAM_TYPE__LOCATION:
                return getLocation();
            case ScxmlPackage.SCXML_PARAM_TYPE__NAME:
                return getName();
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY_ATTRIBUTE:
                if (coreType) return getAnyAttribute();
                return ((FeatureMap.Internal)getAnyAttribute()).getWrapper();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case ScxmlPackage.SCXML_PARAM_TYPE__SCXML_EXTRA_CONTENT:
                ((FeatureMap.Internal)getScxmlExtraContent()).set(newValue);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY:
                ((FeatureMap.Internal)getAny()).set(newValue);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__EXPR:
                setExpr((String)newValue);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__LOCATION:
                setLocation((String)newValue);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__NAME:
                setName((String)newValue);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY_ATTRIBUTE:
                ((FeatureMap.Internal)getAnyAttribute()).set(newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case ScxmlPackage.SCXML_PARAM_TYPE__SCXML_EXTRA_CONTENT:
                getScxmlExtraContent().clear();
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY:
                getAny().clear();
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__EXPR:
                setExpr(EXPR_EDEFAULT);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__LOCATION:
                setLocation(LOCATION_EDEFAULT);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY_ATTRIBUTE:
                getAnyAttribute().clear();
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case ScxmlPackage.SCXML_PARAM_TYPE__SCXML_EXTRA_CONTENT:
                return scxmlExtraContent != null && !scxmlExtraContent.isEmpty();
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY:
                return !getAny().isEmpty();
            case ScxmlPackage.SCXML_PARAM_TYPE__EXPR:
                return EXPR_EDEFAULT == null ? expr != null : !EXPR_EDEFAULT.equals(expr);
            case ScxmlPackage.SCXML_PARAM_TYPE__LOCATION:
                return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
            case ScxmlPackage.SCXML_PARAM_TYPE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case ScxmlPackage.SCXML_PARAM_TYPE__ANY_ATTRIBUTE:
                return anyAttribute != null && !anyAttribute.isEmpty();
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (scxmlExtraContent: ");
        result.append(scxmlExtraContent);
        result.append(", expr: ");
        result.append(expr);
        result.append(", location: ");
        result.append(location);
        result.append(", name: ");
        result.append(name);
        result.append(", anyAttribute: ");
        result.append(anyAttribute);
        result.append(')');
        return result.toString();
    }

} //ScxmlParamTypeImpl
