/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.aql.business.api;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;

public final class TypesUtil {
    private TypesUtil() {
    }

    public static Map<String, Set<IType>> createAQLVariableTypesFromInterpreterContext(IInterpreterContext context, IQueryEnvironment queryEnvironment) {
        LinkedHashMap<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();
        LinkedHashSet<Object> selfTyping = new LinkedHashSet<Object>(2);
        VariableType targetTypeName = context.getTargetType();
        for (TypeName typeName : targetTypeName.getPossibleTypes()) {
            EClassifierType found = TypesUtil.searchEClassifierType(queryEnvironment, typeName);
            if (found == null) continue;
            selfTyping.add(found);
        }
        if (selfTyping.size() == 0) {
            selfTyping.add(new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, EObject.class));
        }
        variableTypes.put("self", selfTyping);
        for (Map.Entry entry : context.getVariables().entrySet()) {
            VariableType typeName = (VariableType)entry.getValue();
            LinkedHashSet<Object> potentialTypes = new LinkedHashSet<Object>(2);
            for (TypeName possibleVariableTypes : typeName.getPossibleTypes()) {
                EClassifierType found = TypesUtil.searchEClassifierType(queryEnvironment, possibleVariableTypes);
                if (found == null) continue;
                potentialTypes.add(found);
            }
            if (potentialTypes.size() == 0) {
                potentialTypes.add(new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, EObject.class));
            }
            variableTypes.put((String)entry.getKey(), potentialTypes);
        }
        return variableTypes;
    }

    private static EClassifierType searchEClassifierType(IQueryEnvironment queryEnvironment, TypeName targetTypeName) {
        EClassifier found = null;
        if (targetTypeName.getPackagePrefix().some()) {
            String typeName = targetTypeName.getClassifierName();
            String nsPrefix = (String)targetTypeName.getPackagePrefix().get();
            found = queryEnvironment.getEPackageProvider().getType(nsPrefix, typeName);
        } else {
            found = queryEnvironment.getEPackageProvider().getType(targetTypeName.getClassifierName());
        }
        if (found != null) {
            return new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, found);
        }
        return null;
    }
}

