/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.ecore;

import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class IndexedSettingsEList
extends BasicEList<EStructuralFeature.Setting> {
    private static final long serialVersionUID = 1L;
    private static final int KNOWNS_MAP_THRESHOLD = 500;
    private Map<EObject, BitSet> knowns;

    protected Object[] newData(int capacity) {
        return new EStructuralFeature.Setting[capacity];
    }

    public boolean add(EStructuralFeature.Setting setting) {
        EObject eObject = setting.getEObject();
        if (this.knowns != null) {
            boolean isKnownFeature = this.isKnown(setting);
            boolean toBeAdded = true;
            if (isKnownFeature) {
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                EStructuralFeature.Setting[] settingData = (EStructuralFeature.Setting[])this.data;
                int i = 0;
                while (i < this.size) {
                    EStructuralFeature.Setting containedSetting = settingData[i];
                    if (containedSetting.getEObject() == eObject && containedSetting.getEStructuralFeature() == eStructuralFeature) {
                        toBeAdded = false;
                        break;
                    }
                    ++i;
                }
            }
            if (toBeAdded) {
                this.addUnique(setting);
            }
            return toBeAdded;
        }
        return super.add((Object)setting);
    }

    private boolean isKnown(EStructuralFeature.Setting setting) {
        BitSet knownFeaturesForThisEObject = this.knowns.get(setting.getEObject());
        if (knownFeaturesForThisEObject != null) {
            return knownFeaturesForThisEObject.get(setting.getEStructuralFeature().getFeatureID());
        }
        return false;
    }

    private void markAsKnown(EStructuralFeature.Setting setting) {
        BitSet knownFeaturesForThisEObject = this.knowns.get(setting.getEObject());
        if (knownFeaturesForThisEObject == null) {
            knownFeaturesForThisEObject = new BitSet();
            this.knowns.put(setting.getEObject(), knownFeaturesForThisEObject);
        }
        knownFeaturesForThisEObject.set(setting.getEStructuralFeature().getFeatureID());
    }

    protected EStructuralFeature.Setting assign(int index, EStructuralFeature.Setting setting) {
        if (this.knowns == null && this.size >= 500) {
            this.knowns = Maps.newHashMapWithExpectedSize((int)this.size);
            EStructuralFeature.Setting[] settingData = (EStructuralFeature.Setting[])this.data;
            int i = 0;
            while (i < this.size) {
                EStructuralFeature.Setting containedSetting = settingData[i];
                this.markAsKnown(containedSetting);
                ++i;
            }
        }
        if (setting != null && this.knowns != null && setting.getEObject() != null && setting.getEStructuralFeature() != null) {
            this.markAsKnown(setting);
        }
        return (EStructuralFeature.Setting)super.assign(index, (Object)setting);
    }

    public void clear() {
        super.clear();
        if (this.knowns != null) {
            this.knowns.clear();
        }
    }
}

