/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoading;
import org.eclipse.sirius.common.tools.api.interpreter.ClasspathChangeCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class BundleClassLoading
implements ClassLoading {
    protected static final String EMF_GENERATED_PACKAGE_EXTENSIONPOINT = "org.eclipse.emf.ecore.generated_package";

    @Override
    public void setClasspathChangeCallback(ClasspathChangeCallback listener) {
    }

    @Override
    public Class<?> findClass(Set<String> projectsToSearchIn, Set<String> plugins, String qualifiedName) {
        Class<?> found = null;
        Iterator<String> it = plugins.iterator();
        while (found == null && it.hasNext()) {
            String bundleID = it.next();
            found = this.loadClassInBundle(bundleID, qualifiedName);
        }
        return found;
    }

    @Override
    public void dispose() {
    }

    private Class<?> loadClassInBundle(String bundleID, String qualifiedName) {
        Bundle requiredBundle = Platform.getBundle((String)bundleID);
        if (requiredBundle != null) {
            return this.loadClassInBundle(requiredBundle, qualifiedName);
        }
        return null;
    }

    private Class<?> loadClassInBundle(Bundle bundle, String qualifiedName) {
        try {
            return bundle.loadClass(qualifiedName);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return null;
    }

    @Override
    public Collection<EPackageLoadingCallback.EPackageDeclarationSource> findEcoreDeclarations(Set<String> projects, Set<String> plugins) {
        LinkedHashSet analyzed = Sets.newLinkedHashSet();
        LinkedHashSet bundlesIDependOn = Sets.newLinkedHashSet();
        for (String currentBundle : Iterables.concat(plugins, projects)) {
            this.addDependencies(currentBundle, analyzed, bundlesIDependOn);
        }
        return this.getEPackagesDeclaredInBundles(bundlesIDependOn);
    }

    protected Collection<EPackageLoadingCallback.EPackageDeclarationSource> getEPackagesDeclaredInBundles(Collection<String> bundles) {
        ArrayList result = Lists.newArrayList();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            HashMultimap contributions = HashMultimap.create();
            IExtensionPoint ep = reg.getExtensionPoint(EMF_GENERATED_PACKAGE_EXTENSIONPOINT);
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] ce = ext.getConfigurationElements();
                String contributorName = ext.getContributor().getName();
                if (bundles.contains(contributorName)) {
                    IConfigurationElement[] iConfigurationElementArray = ce;
                    int n3 = ce.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        String nsURI = element.getAttribute("uri");
                        String className = element.getAttribute("class");
                        String genModel = element.getAttribute("genModel");
                        if (nsURI != null && className != null) {
                            contributions.put((Object)contributorName, (Object)new EPackageLoadingCallback.EPackageDeclaration(nsURI, className, genModel));
                        } else {
                            DslCommonPlugin.getDefault().warning("An EPackage declaration in project " + contributorName + " has been ignored because of missing informations.", new IllegalArgumentException());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            for (String contributor : contributions.keySet()) {
                Collection declarations = contributions.get((Object)contributor);
                if (declarations.size() <= 0) continue;
                result.add(new EPackageLoadingCallback.EPackageDeclarationSource(contributor, declarations, true));
            }
        }
        return result;
    }

    private void addDependencies(String bundleSymbolicName, Set<String> analyzed, Set<String> collectedDependencies) {
        if (!analyzed.contains(bundleSymbolicName)) {
            analyzed.add(bundleSymbolicName);
            Set<String> dependencies = this.getBundleDependencies(bundleSymbolicName);
            collectedDependencies.addAll(dependencies);
            for (String dependency : dependencies) {
                this.addDependencies(dependency, analyzed, collectedDependencies);
            }
        }
    }

    protected Set<String> getBundleDependencies(String bundleSymbolicName) {
        BundleWiring wiring;
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        Bundle currentBundle = Platform.getBundle((String)bundleSymbolicName);
        if (currentBundle != null && (wiring = (BundleWiring)currentBundle.adapt(BundleWiring.class)) != null) {
            for (BundleWire wire : wiring.getRequiredWires("osgi.wiring.bundle")) {
                if (wire.getProvider() == null || wire.getProvider().getBundle() == null) continue;
                dependencies.add(wire.getProvider().getBundle().getSymbolicName());
            }
        }
        return dependencies;
    }
}

