/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.query.CompositeFilterDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.DMappingBasedQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPopupBarEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractEdgeViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrderingHint;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrderingProvider;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.InitializeHiddenElementsCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.ordering.ViewOrderingProviderRegistry;
import org.eclipse.sirius.diagram.ui.tools.internal.providers.decorators.SubDiagramDecoratorProvider;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gef.editpolicies.SiriusSnapFeedbackPolicy;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.RubberbandDragTracker;
import org.eclipse.sirius.viewpoint.DMappingBased;

public abstract class AbstractDDiagramEditPart
extends DiagramEditPart
implements IDDiagramEditPart {
    protected EditPartAuthorityListener authListener = new EditPartAuthorityListener(this);

    public AbstractDDiagramEditPart(View diagramView) {
        super(diagramView);
    }

    @Override
    public final Option<DDiagram> resolveDDiagram() {
        EObject resolveSemanticElement = this.resolveSemanticElement();
        if (resolveSemanticElement instanceof DDiagram) {
            return Options.newSome((Object)((DDiagram)resolveSemanticElement));
        }
        return Options.newNone();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new SiriusPopupBarEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SiriusSnapFeedbackPolicy());
    }

    protected List<?> getModelChildren() {
        ArrayList modelChildren = new ArrayList(super.getModelChildren());
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        return modelChildren;
    }

    protected void handleNotificationEvent(Notification notification) {
        Edge oldValue;
        super.handleNotificationEvent(notification);
        if (NotationPackage.Literals.VIEW__VISIBLE.equals(notification.getFeature()) && notification.getNotifier() instanceof Edge) {
            this.createEditPartForRevealedEdge(notification);
        }
        if ((NotationPackage.eINSTANCE.getDiagram_PersistedEdges().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getDiagram_TransientEdges().equals(notification.getFeature())) && notification.getOldValue() instanceof Edge && "NoteAttachment".equals((oldValue = (Edge)notification.getOldValue()).getType())) {
            this.refresh();
        }
        if (DiagramPackage.eINSTANCE.getDDiagram_ActivatedFilters().equals(notification.getFeature())) {
            this.refresh();
            this.refreshSourceAndTargetOfRevealedEdges(notification);
            SubDiagramDecoratorProvider.refreshEditParts((EditPart)this.getRoot());
        } else if (!(notification.getEventType() != 1 && notification.getEventType() != 2 && notification.getEventType() != 3 || notification.getEventType() == 3 && notification.getNewValue() instanceof Layer && LayerHelper.containsOnlyTools((Layer)((Layer)notification.getNewValue())))) {
            this.refresh();
        }
    }

    protected void createEditPartForRevealedEdge(Notification notification) {
        Option edgeToRefresh = Options.newNone();
        if (1 == notification.getEventType() && !notification.getOldBooleanValue() && notification.getNewBooleanValue()) {
            edgeToRefresh = Options.newSome((Object)((Edge)notification.getNotifier()));
        }
        if (edgeToRefresh.some()) {
            Option<IGraphicalEditPart> targetPart;
            ArrayList<IGraphicalEditPart> editPartsToRefresh = new ArrayList<IGraphicalEditPart>();
            Edge edge = (Edge)edgeToRefresh.get();
            Option<IGraphicalEditPart> sourcePart = this.getEditPartFor(edge.getSource());
            if (sourcePart.some()) {
                editPartsToRefresh.add((IGraphicalEditPart)sourcePart.get());
            }
            if ((targetPart = this.getEditPartFor(edge.getTarget())).some() && !editPartsToRefresh.contains(targetPart.get())) {
                editPartsToRefresh.add((IGraphicalEditPart)targetPart.get());
            }
            for (IGraphicalEditPart editPartToRefresh : editPartsToRefresh) {
                editPartToRefresh.refresh();
            }
        }
    }

    protected void refreshSourceAndTargetOfRevealedEdges(Notification notification) {
        CompositeFilterDescription compositeFilterDescription;
        CompositeFilterDescriptionQuery query;
        FilterDescription test;
        EList<Edge> edgesToRefresh = new EList<Edge>();
        if (4 == notification.getEventType() && (test = (FilterDescription)notification.getOldValue()) instanceof CompositeFilterDescription && (query = new CompositeFilterDescriptionQuery(compositeFilterDescription = (CompositeFilterDescription)test)).isHideCompositeFilter()) {
            EList mappings = query.getHiddenMappings();
            edgesToRefresh = this.getEdges(Lists.newArrayList((Iterable)Iterables.filter((Iterable)mappings, EdgeMapping.class)));
        }
        ArrayList<IGraphicalEditPart> editPartsToRefresh = new ArrayList<IGraphicalEditPart>();
        for (Edge edge : edgesToRefresh) {
            Option<IGraphicalEditPart> targetPart;
            Option<IGraphicalEditPart> sourcePart = this.getEditPartFor(edge.getSource());
            if (sourcePart.some() && !editPartsToRefresh.contains(sourcePart.get())) {
                editPartsToRefresh.add((IGraphicalEditPart)sourcePart.get());
            }
            if (!(targetPart = this.getEditPartFor(edge.getTarget())).some() || editPartsToRefresh.contains(targetPart.get())) continue;
            editPartsToRefresh.add((IGraphicalEditPart)targetPart.get());
        }
        for (IGraphicalEditPart editPartToRefresh : editPartsToRefresh) {
            editPartToRefresh.refresh();
        }
    }

    private EList<Edge> getEdges(Collection<EdgeMapping> edgeMappingsKindOf) {
        BasicEList result = new BasicEList();
        Diagram gmfDiagram = this.getDiagramView();
        for (Edge edge : Iterables.filter((Iterable)gmfDiagram.getEdges(), Edge.class)) {
            EObject element = edge.getElement();
            if (!(element instanceof DEdge) || !new DMappingBasedQuery((DMappingBased)((DEdge)element)).isFromAnyMapping(edgeMappingsKindOf)) continue;
            result.add((Object)edge);
        }
        return result;
    }

    private Option<IGraphicalEditPart> getEditPartFor(View view) {
        Map registry = this.getViewer().getEditPartRegistry();
        if (view != null && registry.containsKey(view) && registry.get(view) instanceof IGraphicalEditPart) {
            return Options.newSome((Object)((IGraphicalEditPart)registry.get(view)));
        }
        return Options.newNone();
    }

    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return this.authListener;
    }

    public void activate() {
        super.activate();
        DDiagram dDiagram = (DDiagram)this.resolveDDiagram().get();
        Session session = new EObjectQuery((EObject)dDiagram).getSession();
        ArrayList<DDiagramElement> hiddenElements = new ArrayList<DDiagramElement>();
        DDiagramQuery dDiagramQuery = new DDiagramQuery(dDiagram);
        for (DDiagramElement diagramElement : dDiagram.getDiagramElements()) {
            if (dDiagramQuery.isHidden(session, diagramElement)) {
                hiddenElements.add(diagramElement);
                continue;
            }
            if (!dDiagramQuery.isLabelHidden(session, diagramElement)) continue;
            hiddenElements.add(diagramElement);
        }
        if (!hiddenElements.isEmpty()) {
            DDiagramEditorImpl diagramEditor;
            if (this.getEditingDomain() instanceof InternalTransactionalEditingDomain && ((InternalTransactionalEditingDomain)this.getEditingDomain()).getActiveTransaction() == null) {
                InitializeHiddenElementsCommand command = new InitializeHiddenElementsCommand(this.getEditingDomain(), dDiagram, hiddenElements);
                if (command != null) {
                    this.executeCommand((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new GMFCommandWrapper(this.getEditingDomain(), (Command)command)));
                }
            } else {
                dDiagram.getHiddenElements().addAll(hiddenElements);
            }
            if ((diagramEditor = (DDiagramEditorImpl)this.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID")) != null && diagramEditor.getTabbar() != null) {
                diagramEditor.getTabbar().reinitToolBar(diagramEditor.getDiagramGraphicalViewer().getSelection());
            }
        }
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
        auth.addAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
        this.getEditPartAuthorityListener().refreshEditMode();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
        auth.removeAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
        super.deactivate();
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        org.eclipse.gef.commands.Command originalCommand = super.getCommand(request);
        if (request instanceof ArrangeRequest && originalCommand != null) {
            org.eclipse.gef.commands.Command populateViewOrder = new org.eclipse.gef.commands.Command(originalCommand.getLabel()){

                public void execute() {
                    AbstractDDiagramEditPart.this.populateViewOrderings();
                }
            };
            originalCommand = populateViewOrder.chain(originalCommand);
        }
        return originalCommand;
    }

    protected void populateViewOrderings() {
        DDiagram dDiagram;
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagram && (dDiagram = (DDiagram)element).getDescription() != null) {
            DiagramDescription desc = dDiagram.getDescription();
            LinkedList allMappings = new LinkedList();
            Session session = null;
            if (dDiagram instanceof DSemanticDiagram) {
                session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)dDiagram).getTarget());
            }
            allMappings.addAll(new DiagramComponentizationManager().getAllContainerMappings(session.getSelectedViewpoints(false), desc));
            allMappings.addAll(new DiagramComponentizationManager().getAllNodeMappings(session.getSelectedViewpoints(false), desc));
            allMappings.addAll(new DiagramComponentizationManager().getAllEdgeMappings(session.getSelectedViewpoints(false), desc));
            for (DiagramElementMapping diagramElementMapping : allMappings) {
                ViewOrderingProvider provider = ViewOrderingProviderRegistry.getInstance().getProvider(diagramElementMapping);
                if (provider == null) continue;
                ViewOrdering viewOrdering = provider.getViewOrdering(diagramElementMapping);
                if (viewOrdering instanceof AbstractEdgeViewOrdering) {
                    ViewOrderingHint.getInstance().putEdgeViewOrdering(this.getNotationView(), (AbstractEdgeViewOrdering)viewOrdering);
                    continue;
                }
                if (viewOrdering == null) continue;
                ViewOrderingHint.getInstance().putViewOrdering(this.getNotationView(), viewOrdering);
            }
        }
        for (IGraphicalEditPart part : Iterables.filter((Iterable)this.getChildren(), IGraphicalEditPart.class)) {
            this.populateViewOrderings(part);
        }
    }

    private void populateViewOrderings(IGraphicalEditPart editPart) {
        ContainerMapping containerMapping;
        EObject element = editPart.resolveSemanticElement();
        if (element instanceof DNodeContainer && (containerMapping = ((DNodeContainer)element).getActualMapping()) != null) {
            for (DiagramElementMapping diagramElementMapping : containerMapping.getAllMappings()) {
                ViewOrdering viewOrdering;
                ViewOrderingProvider provider = ViewOrderingProviderRegistry.getInstance().getProvider(diagramElementMapping);
                if (provider == null || (viewOrdering = provider.getViewOrdering(diagramElementMapping)) == null) continue;
                ViewOrderingHint.getInstance().putViewOrdering(editPart.getNotationView(), viewOrdering);
            }
        }
        for (IGraphicalEditPart part : Iterables.filter((Iterable)editPart.getChildren(), IGraphicalEditPart.class)) {
            this.populateViewOrderings(part);
        }
    }

    public DragTracker getDragTracker(Request req) {
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new RubberbandDragTracker();
    }
}

