/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.synchronizer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.synchronizer.ChildCreationSupport;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.MappingHiearchyTable;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.PreRefreshStatus;
import org.eclipse.sirius.synchronizer.RefreshPlan;
import org.eclipse.sirius.synchronizer.RefreshPlanner;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.synchronizer.SignatureProvider;

public class ModelToModelSynchronizer {
    private SemanticPartitionInvalidator evaluator;
    private MappingHiearchyTable table;
    private PreRefreshStatus pre;
    private SignatureProvider signatureProvider;

    public ModelToModelSynchronizer(SemanticPartitionInvalidator evaluator, MappingHiearchyTable table, PreRefreshStatus pre, SignatureProvider signProvider) {
        this.evaluator = evaluator;
        this.table = table;
        this.pre = pre;
        this.signatureProvider = signProvider;
    }

    public void update(CreatedOutput container, boolean fullRefresh) {
        this.update(container, fullRefresh, (IProgressMonitor)new NullProgressMonitor());
    }

    public void update(CreatedOutput container, boolean fullRefresh, IProgressMonitor monitor) {
        try {
            RefreshPlan plan = new RefreshPlanner(this.table, this.evaluator, this.pre, this.signatureProvider).computePlan(container);
            Collection<CreatedOutput> descriptorsToDelete = plan.getDescriptorsToDelete();
            Collection<OutputDescriptor> descriptorsToCreate = plan.getDescriptorsToCreate();
            Collection<CreatedOutput> descriptorsToRefresh = plan.getDescriptorsToRefresh();
            Option<? extends ChildCreationSupport> childSupport = container.getChildSupport();
            if (container.synchronizeChildren() || fullRefresh) {
                int nbSteps = 1 + plan.getDescriptorToUpdateMapping().size() + descriptorsToRefresh.size();
                if (childSupport.some()) {
                    nbSteps += descriptorsToCreate.size() * 2 + descriptorsToDelete.size() + descriptorsToRefresh.size();
                }
                monitor.beginTask("Synchronization", nbSteps);
                if (childSupport.some()) {
                    ChildCreationSupport containerChildSupport = (ChildCreationSupport)childSupport.get();
                    for (CreatedOutput outDesc : descriptorsToDelete) {
                        containerChildSupport.deleteChild(outDesc);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                    }
                    ArrayList newlyCreated = Lists.newArrayList();
                    for (OutputDescriptor outDesc : descriptorsToCreate) {
                        CreatedOutput newOne = containerChildSupport.createChild(outDesc);
                        newOne.refresh();
                        newlyCreated.add(newOne);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                    }
                    Iterable createdOrRefreshed = Iterables.concat(descriptorsToRefresh, (Iterable)newlyCreated);
                    containerChildSupport.reorderChilds(createdOrRefreshed);
                    for (CreatedOutput createdOutput : createdOrRefreshed) {
                        this.update(createdOutput, fullRefresh);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                    }
                }
                for (CreatedOutput outDesc : plan.getDescriptorToUpdateMapping()) {
                    outDesc.updateMapping();
                    outDesc.refresh();
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                }
                for (CreatedOutput outDesc : descriptorsToRefresh) {
                    outDesc.refresh();
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                }
            } else {
                EObject createdElement;
                monitor.beginTask("Synchronization", 1);
                if (childSupport.some() && (createdElement = container.getCreatedElement()) != null && descriptorsToRefresh.isEmpty() && !descriptorsToCreate.isEmpty()) {
                    ChildCreationSupport containerChildSupport = (ChildCreationSupport)childSupport.get();
                    OutputDescriptor outDesc = descriptorsToCreate.iterator().next();
                    containerChildSupport.createChild(outDesc);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }
}

