/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.commands;

import java.util.Comparator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.ui.tools.internal.commands.DLineSorter;

public class SortDLinesCommand
extends RecordingCommand {
    private DTable dTable;
    private Comparator<DLine> dLineSorter;

    public SortDLinesCommand(TransactionalEditingDomain domain, DTable dTable, DColumn dColumn, int sortDirection) {
        super(domain, String.valueOf(sortDirection == 128 ? "Ascending " : "Descending ") + "lines sorting");
        this.dTable = dTable;
        this.dLineSorter = new DLineSorter(dColumn, sortDirection);
    }

    protected void doExecute() {
        this.sortLinesBy((LineContainer)this.dTable);
    }

    private void sortLinesBy(LineContainer lineContainer) {
        if (!lineContainer.getLines().isEmpty()) {
            ECollections.sort((EList)lineContainer.getLines(), this.dLineSorter);
            for (DLine line : lineContainer.getLines()) {
                this.sortLinesBy((LineContainer)line);
            }
        }
    }
}

