/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.sirius.business.api.color.AbstractColorUpdater;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public class SiriusAssert
extends Assert {
    public static void assertNotEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && !expected.equals(actual)) {
            return;
        }
        SiriusAssert.failEquals(message, expected, actual);
    }

    public static void assertNotEquals(Object expected, Object actual) {
        SiriusAssert.assertNotEquals(null, expected, actual);
    }

    public static void failEquals(String message, Object expected, Object actual) {
        throw new ComparisonFailure(message, String.valueOf(expected), String.valueOf(actual));
    }

    public static void assertSameRGB(String message, RGBValues expected, RGBValues actual) {
        if (!AbstractColorUpdater.areEquals((RGBValues)expected, (RGBValues)actual)) {
            throw new ComparisonFailure(message, String.valueOf(expected), String.valueOf(actual));
        }
    }

    public static void assertFileExists(String wksPath) {
        IFile fileToTest = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(wksPath));
        try {
            fileToTest.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((String)("The file \"" + wksPath + "\" does not exist."), (boolean)fileToTest.exists());
    }
}

