/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreeMapping;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeMenuListener;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewer;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.AbstractToolAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.CreateToolItemAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.DeleteTreeItemsAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.EditorCreateTreeItemMenuAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.TreeItemExpansionManager;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.DTreeContentProvider;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.DTreeDecoratingLabelProvider;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.DTreeItemDropListener;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.DTreeItemEditingSupport;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.TreeUIUpdater;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTableViewerManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.sirius.ui.tools.internal.editor.DTableColumnViewerEditorActivationStrategy;
import org.eclipse.sirius.ui.tools.internal.editor.DTableTreeFocusListener;
import org.eclipse.sirius.ui.tools.internal.editor.DescriptionFileChangedNotifier;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.adapters.ModelDragTargetAdapter;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class DTreeViewerManager
extends AbstractDTableViewerManager {
    public static final String REFRESH_IMG = "tree/refresh";
    public static final String DELETE_IMG = "tree/delete";
    public static final String CREATE_TREE_ITEM_IMG = "tree/newTreeItem";
    private final ITreeCommandFactory treeCommandFactory;
    private TreeUIUpdater treeUIUpdater;
    private DescriptionFileChangedNotifier descriptionFileChangedNotifier;
    private DTreeContentProvider dTreeContentProvider;
    private DTreeMenuListener actualMenuListener;
    private final EditorCreateTreeItemMenuAction createTreeItemMenu = new EditorCreateTreeItemMenuAction();

    static {
        imageRegistry.put(REFRESH_IMG, ImageDescriptor.createFromURL((URL)((URL)TreeUIPlugin.INSTANCE.getImage(REFRESH_IMG))));
        imageRegistry.put(DELETE_IMG, ImageDescriptor.createFromURL((URL)((URL)TreeUIPlugin.INSTANCE.getImage(DELETE_IMG))));
        imageRegistry.put(CREATE_TREE_ITEM_IMG, ImageDescriptor.createFromURL((URL)((URL)TreeUIPlugin.INSTANCE.getImage(CREATE_TREE_ITEM_IMG))));
    }

    public DTreeViewerManager(Composite parent, DTree input, TransactionalEditingDomain editingDomain, ModelAccessor accessor, ICommandFactory tableCommandFactory, AbstractDTreeEditor treeEditor) {
        super(parent, (DRepresentation)input, editingDomain, accessor, tableCommandFactory, treeEditor);
        this.treeCommandFactory = (ITreeCommandFactory)tableCommandFactory;
        this.createTreeViewer(parent);
    }

    public static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }

    protected void createTreeViewer(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeLayout);
        DTreeViewer dTreeViewer = new DTreeViewer(composite, 770, this.getAccessor().getPermissionAuthority());
        this.treeViewer = dTreeViewer;
        new TreeItemExpansionManager(dTreeViewer.getTree(), this.getSession());
        this.treeViewer.getTree().addFocusListener((FocusListener)new DTableTreeFocusListener(this.tableEditor, this.treeViewer.getTree()));
        this.treeViewer.setUseHashlookup(true);
        this.treeUIUpdater = new TreeUIUpdater(dTreeViewer, this.dRepresentation);
        this.descriptionFileChangedNotifier = new DescriptionFileChangedNotifier((AbstractDTableViewerManager)this);
        this.dTreeContentProvider = new DTreeContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.dTreeContentProvider);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        AdapterFactory adapterFactory = TreeUIPlugin.getPlugin().getItemProvidersAdapterFactory();
        DTreeDecoratingLabelProvider labelProvider = new DTreeDecoratingLabelProvider(adapterFactory, decorator);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
        this.fillMenu();
        this.initializeEditingSupport();
        this.initializeDragAndDropSupport();
        this.initializeKeyBindingSupport();
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager((TreeViewer)this.treeViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.treeViewer));
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)new DTableColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer), (int)58);
        this.treeViewer.setInput((Object)this.dRepresentation);
        this.treeViewer.setExpandedElements(TreeHelper.getExpandedItems((DTree)((DTree)this.dRepresentation)).toArray());
    }

    private void initializeKeyBindingSupport() {
        this.treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    DeleteTreeItemsAction deleteItemsAction = new DeleteTreeItemsAction(DTreeViewerManager.this.getEditingDomain(), DTreeViewerManager.this.getTreeCommandFactory());
                    deleteItemsAction.setItems(DTreeViewerManager.this.getSelectedItems());
                    if (deleteItemsAction.canExecute()) {
                        deleteItemsAction.run();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private Session getSession() {
        return SessionManager.INSTANCE.getSession(((DTree)this.dRepresentation).getTarget());
    }

    protected void initializeEditingSupport() {
        DslCommonPlugin.PROFILER.startWork("Add a column in the SWT table");
        Option<ViewerColumn> optionViewerColumn = this.getViewerColumn();
        if (optionViewerColumn.some()) {
            ViewerColumn treeColumn = (ViewerColumn)optionViewerColumn.get();
            treeColumn.setEditingSupport((EditingSupport)new DTreeItemEditingSupport((TreeViewer)this.treeViewer, this.getEditingDomain(), this.getAccessor(), this.getTreeCommandFactory(), this.getEditor()));
        }
        DslCommonPlugin.PROFILER.stopWork("Add a column in the SWT table");
    }

    protected void initializeDragAndDropSupport() {
        int supportedOperations = 6;
        AbstractDTreeViewer selectionProvider = this.treeViewer;
        this.treeViewer.addDragSupport(supportedOperations, (Transfer[])new ByteArrayTransfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ModelDragTargetAdapter((ISelectionProvider)selectionProvider));
        this.treeViewer.addDropSupport(supportedOperations, (Transfer[])new ByteArrayTransfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DTreeItemDropListener((Viewer)this.treeViewer, this.editingDomain, this.treeCommandFactory, this.accessor));
    }

    private Option<ViewerColumn> getViewerColumn() {
        Option viewerColumn = Options.newNone();
        Class<ColumnViewer> columnViewerClass = ColumnViewer.class;
        try {
            Method method = columnViewerClass.getDeclaredMethod("getViewerColumn", Integer.TYPE);
            method.setAccessible(true);
            Object invoke = method.invoke((Object)this.treeViewer, 0);
            if (invoke instanceof ViewerColumn) {
                viewerColumn = Options.newSome((Object)((ViewerColumn)invoke));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return viewerColumn;
    }

    public void fillMenu() {
        if (this.descriptionFileChanged) {
            this.descriptionFileChanged = false;
            HashMap<TreeMapping, List<AbstractToolAction>> mappingToCreateActions = new HashMap<TreeMapping, List<AbstractToolAction>>();
            ArrayList<AbstractToolAction> createActionsForTree = new ArrayList<AbstractToolAction>();
            this.calculateAvailableMenus(mappingToCreateActions, createActionsForTree);
            this.mgr.setRemoveAllWhenShown(true);
            if (this.actualMenuListener != null) {
                this.mgr.removeAll();
                this.actualMenuListener.setMappingToCreateActions(mappingToCreateActions);
                this.actualMenuListener.setCreateActionsForTree(createActionsForTree);
            } else {
                this.actualMenuListener = new DTreeMenuListener((DTree)this.dRepresentation, this, mappingToCreateActions, createActionsForTree);
                this.mgr.addMenuListener((IMenuListener)this.actualMenuListener);
                Menu menu = this.mgr.createContextMenu(this.treeViewer.getControl());
                this.treeViewer.getControl().setMenu(menu);
                this.tableEditor.getSite().registerContextMenu(this.mgr, (ISelectionProvider)this.treeViewer);
            }
            this.getCreateTreeItemMenu().update(createActionsForTree);
        }
    }

    public Collection<DTreeItem> getSelectedItems() {
        ArrayList result = Lists.newArrayList();
        if (this.treeViewer.getTree().getSelectionCount() > 0) {
            TreeItem[] treeItemArray = this.treeViewer.getTree().getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object data = item.getData();
                if (data instanceof DTreeItem) {
                    result.add((DTreeItem)data);
                }
                ++n2;
            }
        }
        return result;
    }

    private void calculateAvailableMenus(Map<TreeMapping, List<AbstractToolAction>> mappingToCreateActions, List<AbstractToolAction> createActionsForTree) {
        TreeDescription treeDescription = ((DTree)this.dRepresentation).getDescription();
        if (treeDescription != null) {
            this.calculateAvailableMenusForLine((EList<TreeItemMapping>)treeDescription.getSubItemMappings(), mappingToCreateActions, new ArrayList<TreeItemMapping>());
            EList createLineTools = treeDescription.getCreateTreeItem();
            for (TreeItemCreationTool createTool : createLineTools) {
                CreateToolItemAction createLineAction = new CreateToolItemAction(createTool, this.getEditingDomain(), this.getTreeCommandFactory());
                createLineAction.setTable((DTree)this.dRepresentation);
                createActionsForTree.add(createLineAction);
            }
        }
    }

    private void calculateAvailableMenusForLine(EList<TreeItemMapping> lineMappings, Map<TreeMapping, List<AbstractToolAction>> mappingToCreateActions, List<TreeItemMapping> processedLineMappings) {
        for (TreeItemMapping treeItemMapping : lineMappings) {
            if (treeItemMapping != null && !mappingToCreateActions.keySet().contains(treeItemMapping)) {
                EList createTools = treeItemMapping.getCreate();
                List<AbstractToolAction> existingCreateTools = mappingToCreateActions.get(treeItemMapping);
                if (existingCreateTools == null) {
                    existingCreateTools = new ArrayList<AbstractToolAction>();
                }
                for (TreeItemCreationTool createTool : createTools) {
                    existingCreateTools.add(new CreateToolItemAction(createTool, this.getEditingDomain(), this.getTreeCommandFactory()));
                }
                mappingToCreateActions.put((TreeMapping)treeItemMapping, existingCreateTools);
            }
            if (treeItemMapping == null || processedLineMappings.contains(treeItemMapping)) continue;
            processedLineMappings.add(treeItemMapping);
            this.calculateAvailableMenusForLine((EList<TreeItemMapping>)treeItemMapping.getAllSubMappings(), mappingToCreateActions, processedLineMappings);
        }
    }

    public ITreeCommandFactory getTreeCommandFactory() {
        return this.treeCommandFactory;
    }

    public boolean isSameTree(DTree tree) {
        return ((DTree)this.dRepresentation).equals(tree);
    }

    public void setDescriptionFileChanged(boolean modified) {
        this.descriptionFileChanged = modified;
    }

    public EditorCreateTreeItemMenuAction getCreateTreeItemMenu() {
        return this.createTreeItemMenu;
    }

    public void dispose() {
        this.descriptionFileChangedNotifier.dispose();
        this.descriptionFileChangedNotifier = null;
        this.treeUIUpdater.dispose();
        this.treeUIUpdater = null;
        this.dTreeContentProvider.dispose();
        this.dTreeContentProvider = null;
        super.dispose();
        this.createTreeItemMenu.dispose();
    }
}

